// kvncauthwdg.cpp
// Author: Markus Wuebben <markus.wuebben@kde.org>
// This code is published under the GPL.

#include <qlabel.h>
#include <qlayout.h>
#include <qframe.h>
#include <qstring.h>
#include <qlabel.h>
#include <qfont.h>
#include <qlineedit.h>
#include <kseparator.h>
#include <klocale.h>
#include "krfbconnection.h"
#include "kvncauthdlg.h"
#include "kvncauthdlg.moc"

KVNCAuthDialog::KVNCAuthDialog( KRFBConnection *con,
				QWidget *parent, const char * name )
  : KDialogBase( Plain,
		 i18n( "Enter password..." ), 
		 Help|Ok|Cancel, Ok,
		 parent, name,
		 true, true )
{
  //  view = viewer;
  setHelp( "kvnc/index.html", QString::null );

  QFrame *frame = plainPage();
  QVBoxLayout *outer = new QVBoxLayout( frame, marginHint(), spacingHint() );

  // Title block
  QString temp;
  temp.sprintf( i18n( "Enter password for %s"), con->host().data() );
 
  QLabel *titleLabel = new QLabel( temp, frame );
  QFont titleFont = titleLabel->font();
  titleFont.setBold( true );
  titleLabel->setFont( titleFont );
  KSeparator *titleSep = new KSeparator( frame );
  titleSep->setFrameStyle( QFrame::HLine|QFrame::Plain );
  outer->addWidget( titleLabel );
  outer->addWidget( titleSep );

  // Main block
  QHBoxLayout *inner = new QHBoxLayout( outer, spacingHint() );
  QLabel *label1 = new QLabel( i18n( "&Password:" ), frame );

  passwordEdit = new QLineEdit( frame );
  label1->setBuddy( passwordEdit );
  passwordEdit->setEchoMode( QLineEdit::Password );
  passwordEdit->setFocus();

  inner->addWidget( label1 );
  inner->addWidget( passwordEdit );
}

KVNCAuthDialog::~KVNCAuthDialog()
{
}

void KVNCAuthDialog::slotOk()
{
  done(1);
}









