#include <kapp.h>
#include <klocale.h>
#include <qlabel.h>

#include "kvncaboutdlg.h"
#include "version.h"
#include "kvncaboutdlg.moc"

KVNCAboutDlg::KVNCAboutDlg( QWidget *parent, const char *name, bool modal )
  : KAboutDialog( AbtAppStandard,
		  "keystone",
		  Close, Close, parent, name, modal)
{
  setTitle( i18n("Keystone - The KDE Virtual Network Computer Client") );
  setProduct( QString(KVNCAPP), QString(KVNCVERSIONSTRING), 
	      QString("Richard Moore"), QString("1999-2000") );

  static const QString text1 = i18n("\n"
    "This program uses modified code from khexedit, and kvncviewer.\n"
    "Thanks to the authors of these programs, Espen Sand and Markus\n"
    "Wuebben respectively.\n\n"
    "This program includes parts of the QNetwork extension which is\n"
    "currently unreleased. If you want to obtain the whole QNetwork\n"
    "extension, it is available via the Qt snapshots. Information on\n"
    "obtaining these can be found on the Troll Tech website at\n"
    "http://www.trolltech.com/ the code used under the terms of the\n"
    "Qt Public License (QPL). You can identify the classes that are\n"
    "under the QPL by the initial 'Q' in the file and classnames. All\n"
    "the other classes are under the GPL.\n\n"
    "Thanks are also due to ORL for releasing VNC as GPL and making\n"
    "this program possible.\n\n" );

  static const QString text2 = i18n("\n"
    "This program is free software; you can redistribute it and/or modify\n"
    "it under the terms of the GNU General Public License as published by\n"
    "the Free Software Foundation; either version 2 of the License, or\n"
    "(at your option) any later version.\n"
    "\n"
    "This program is distributed in the hope that it will be useful,\n"
    "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
    "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
    "GNU General Public License for more details.\n"
    "\n"
    "You should have received a copy of the GNU General Public License\n"
    "along with this program; if not, write to the Free Software\n"
    "Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n"
    "\n\n"
    "The full text of the GPL is in the file LICENSE.GPL, and the full\n"
    "text of the QPL is in the file LICENSE.QPL.\n\n" );
  
  KAboutContainer *c=addContainerPage(i18n("&About"), AlignCenter, AlignLeft );
  if( c != 0 )
  {
    static const QString keystone = i18n(""
      "<qt>"
      "<dl>"
      "<dt><b>keystone</b> n.</dt>"
      "<dd><b>1.</b>The central stone at the top of an arch or the top "
      "stone of a dome or vault.</dd>"
      "<dd><b>2.</b>Something that is necessary to connect other related "
      "things.</dd>"
      "</dl>"
      "</qt>" );

    QLabel *keystoneLabel = new QLabel( keystone, this );
    keystoneLabel->setFrameStyle( QFrame::WinPanel | QFrame::Plain );
    keystoneLabel->setBackgroundColor( Qt::white );
    c->addWidget( keystoneLabel );

    static const QString reasonToMailMe = i18n(""
      "This is the first release of Keystone, so there are a number of\n"
      "missing features. The missing features are mostly in the area \n"
      "of configuration. I intend, for example, to allow for per-URL\n"
      "settings, but I haven't had the time to implement it yet. Currently\n"
      "there is no documentation.\n\n"
      "The protocol implementation used by Keystone is a ground up rewrite\n"
      "using the QNetwork extension, I am very interested to hear of any\n"
      "protocol problems such as difficulty in connecting to a particular\n"
      "VNC server implementation." );
    c->addWidget( new QLabel( reasonToMailMe, this ) );

    c->addPerson(
      QString::null,
      QString("rich@kde.org"),
      QString("http://apps.cx/kvnc/"),
      QString::null,
      true );
  }
  
  addTextPage( i18n("C&ontributors"), text1 );
  addTextPage( i18n("&Licence agreement"), text2 );
}

KVNCAboutDlg::~KVNCAboutDlg()
{
  // Nothing to do
}



