/* 
 *  Copyright (C) 1999-2000 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _PEOPLE_H_
#define _PEOPLE_H_ 


#include <qwidget.h>
#include <peoplesearch.h>


class QLineEdit;
class QListView;
class QPushButton;
class QLabel;
class PeopleSiteManager;
class PeopleResultView;


class PeopleTopLevel : public QWidget
{
    Q_OBJECT
    
public:
    PeopleTopLevel(QWidget *parent, const char *name=0);
    ~PeopleTopLevel();
    
protected slots:
    void slotSearch();
    void slotCancel();
    void slotResult(KIO::Job*);
    void processItem(const QString &sitename, const QString &name,
                     const QString &email, const QString &phone, const LdapItem &item);
    void emailActivated(const QString &email);
    
private:
    QLineEdit *wordsedit;
    QListView *sitebox;
    QPushButton *searchbutton, *cancelbutton;
    PeopleResultView *resultbox;
    QLabel *foundlabel;
    QList<PeopleSearch> jobs;
    PeopleSiteManager *man;
    
  void updateButtons();
};
 
#endif 
