#include "toplevel.h"
#include "mainwidget.h"
#include <kapp.h>
#include <klocale.h>
#include <kmenubar.h>
#include <kprogress.h>
#include <kstdaccel.h>
#include <kiconloader.h>

KPTopLevel::KPTopLevel(const char *name)
    : KTMainWindow(name)
{
    mainWidget = new KPMainWidget(this);
    KMenuBar *mbar = menuBar();

    fileMnu = new QPopupMenu(this);
    fileMnu->insertItem(i18n("&Open"), mainWidget, SLOT(slotLoad()),
                        KStdAccel::key(KStdAccel::Open), FileOpen);
    fileMnu->insertItem(i18n("&Save current bitmap"), mainWidget,
                        SLOT(slotSaveCurrentBitmap()),
						KStdAccel::key(KStdAccel::Save), SaveSingle);
    fileMnu->insertItem(i18n("Save all bitmaps"), mainWidget,
                        SLOT(slotSaveAllBitmaps()), 0, SaveAll);
    fileMnu->insertItem(i18n("Save all in C++ Header"), mainWidget,
                        SLOT(slotSaveCHeader()), 0, SaveHeader);
    fileMnu->insertItem(i18n("Save QCOORD Arrays"), mainWidget,
                        SLOT(slotSavePointArray()), 0, SavePoints);
    fileMnu->insertItem(i18n("Close"), mainWidget, SLOT(slotReset()),
                        KStdAccel::key(KStdAccel::Close), FileClose);
    fileMnu->insertItem(i18n("&Quit"), kapp, SLOT(quit()),
						KStdAccel::key(KStdAccel::Quit));
    fileMnu->setItemEnabled(SaveSingle, false);
    fileMnu->setItemEnabled(SaveAll, false);
    fileMnu->setItemEnabled(SaveHeader, false);
    fileMnu->setItemEnabled(SavePoints, false);
    fileMnu->setItemEnabled(FileClose, false);
    mbar->insertItem(i18n("&File"), fileMnu);

    zoomMnu = new QPopupMenu(this);
    zoomMnu->insertItem(i18n("Zoom in"), mainWidget, SLOT(slotIncreaseScale()),
                        KStdAccel::key(KStdAccel::ZoomIn), ZoomIn);
    zoomMnu->insertItem(i18n("Zoom out"), mainWidget, SLOT(slotDecreaseScale()),
                        KStdAccel::key(KStdAccel::ZoomOut), ZoomOut);
    zoomMnu->setItemEnabled(ZoomIn, false);
    zoomMnu->setItemEnabled(ZoomOut, false);
    
    mbar->insertItem(i18n("&Zoom"), zoomMnu);

    mbar->insertItem(i18n("&Help"),
                     helpMenu(i18n("KDE Pixmap2Bitmap\n(C)Daniel M. Duley <mosfet@kde.org>"), false));

    KToolBar *tBar = toolBar();
    tBar->insertButton(BarIcon("fileopen"), FileOpen, SIGNAL(clicked()),
                       mainWidget, SLOT(slotLoad()), true,
                       i18n("Open Image"));
    tBar->insertButton(BarIcon("filefloppy"), SaveSingle, SIGNAL(clicked()),
                       mainWidget, SLOT(slotSaveCurrentBitmap()), false,
                       i18n("Save Current Bitmap"));
    tBar->insertButton(BarIcon("close"), FileClose, SIGNAL(clicked()),
                       mainWidget, SLOT(slotReset()), false,
                       i18n("Close Image"));
    tBar->insertLineSeparator();
    tBar->insertButton(BarIcon("viewmag+"), ZoomIn, SIGNAL(clicked()),
                       mainWidget, SLOT(slotIncreaseScale()), false,
                       i18n("Zoom In"));
    tBar->insertButton(BarIcon("viewmag-"), ZoomOut, SIGNAL(clicked()),
                       mainWidget, SLOT(slotDecreaseScale()), false,
                       i18n("Zoom Out"));
    
    KStatusBar *status = statusBar();
    status->insertItem("100%", Zoom);
    progress = new KProgress(0, 100, 0, KProgress::Horizontal, status);
    progress->setTextEnabled(true);
    status->addWidget(progress);

    status->insertItem(i18n("Pixmap2Bitmaps (C)D.M. Duley<mosfet@kde.org>"),
                       Message);
    
    setView(mainWidget);
    setCaption(i18n("KDE Pixmap2Bitmaps"));
    resize(400, 200);
}

void KPTopLevel::slotMessage(const QString &msg)
{
    statusBar()->changeItem(msg, Message);
}

void KPTopLevel::slotProgress(int val)
{
    progress->setValue(val);
}

void KPTopLevel::slotZoom(const QString &str)
{
    statusBar()->changeItem(str, Zoom);
}

void KPTopLevel::slotSaveEnabled(bool en)
{
    toolBar()->setItemEnabled(SaveSingle, en);
    fileMnu->setItemEnabled(SaveSingle, en);
    fileMnu->setItemEnabled(SaveAll, en);
    fileMnu->setItemEnabled(SaveHeader, en);
    fileMnu->setItemEnabled(SavePoints, en);
}

void KPTopLevel::slotCloseEnabled(bool en)
{
    toolBar()->setItemEnabled(FileClose, en);
    fileMnu->setItemEnabled(FileClose, en);
}

void KPTopLevel::slotZoomInEnabled(bool en)
{
    toolBar()->setItemEnabled(ZoomIn, en);
    zoomMnu->setItemEnabled(ZoomIn, en);
}

void KPTopLevel::slotZoomOutEnabled(bool en)
{
    toolBar()->setItemEnabled(ZoomOut, en);
    zoomMnu->setItemEnabled(ZoomOut, en);
}

void KPTopLevel::load(const QString &s)
{
    mainWidget->load(s);
}

#include "toplevel.moc"



