#include <qstring.h>
#include <qfile.h>

#include <kapp.h>
#include <kimageio.h>
#include <kdebug.h>
#include <stdlib.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>

#include "kpaint.h"
#include "version.h"

static const char *description = 
	I18N_NOOP("KDE Paint Program");

static KCmdLineOptions options[] =
{
   { "+[file]", I18N_NOOP("File or URL to open"), 0 },
   { 0, 0, 0 }
};

int openwins= 0;

int main( int argc, char **argv )
{
  KAboutData aboutData(APPNAME, I18N_NOOP("KPaint"), 
    APPVERSTR, description, KAboutData::License_GPL, 
    "(c) 1999-2000, Various KDE Developers");
  aboutData.addAuthor("Richard J. Moore",0, "rich@kde.org");
  aboutData.addAuthor("Robert Williams",0, "rwilliams@jrcmaui.com");
  aboutData.addAuthor("Mario Weilguni",0, "mweilguni@kde.org");
  aboutData.addAuthor("Christian Oppel",0, "uzs84g@uni-bonn.de");
  
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.
  
  
  KApplication kpaintApp;

  KImageIO::registerFormats();

  KPaint *kp;

  if (kpaintApp.isRestored()) {
    // Use new RESTORE macro
    RESTORE(KPaint);
  }
  else {
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    if (args->count() == 0)
    {
      kp= new KPaint();
    }
    else {
      kp= new KPaint( QFile::decodeName(args->arg(0)) );
    }
    kp->show();
  }

  QObject::connect(&kpaintApp, SIGNAL(lastWindowClosed()),
		   &kpaintApp, SLOT(quit()));

  return kpaintApp.exec();
}

