#include "kgv_view.h"
#include "kgv_miniwidget.h"
#include <kinstance.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kaction.h>
#include <kstdaction.h>

extern "C"{
  void *init_libkghostview()
  {
    return new KGVFactory;
  }
};

KInstance *KGVFactory::s_instance = 0L;

KGVFactory::KGVFactory()
{
    KGlobal::locale()->insertCatalogue( QString::fromLatin1("kghostview"));
}

KGVFactory::~KGVFactory()
{
    if ( s_instance )
        delete s_instance;

    s_instance = 0;
}

QObject* KGVFactory::create(QObject *parent , const char *name , const char*,
                            const QStringList & )
{
    QObject *obj = new KGVPart( (QWidget *)parent, name );
    emit objectCreated( obj );
    return obj;
}

KInstance *KGVFactory::instance()
{
    if ( !s_instance )
        s_instance = new KInstance( "kghostview" );
    return s_instance;
}

KGVPart::KGVPart( QWidget *parent, const char *name )
 : KParts::ReadOnlyPart( parent, name )
{
    setInstance( KGVFactory::instance() );
    w = new KGVMiniWidget( parent );
    // Clicking or tabbing on it should make it active (required by KParts)
    w->setFocusPolicy( QWidget::StrongFocus );
    setWidget( w );


    KStdAction::saveAs ( miniWidget(), SLOT (saveAs()),
			 actionCollection());

  QStringList orientations;
  orientations.append (i18n("Portrait"));
  orientations.append (i18n("Landscape"));
  orientations.append (i18n("Upside Down"));
  orientations.append (i18n("Seascape"));

  orientation =
    new KSelectAction (i18n("&Orientation"), 0, 0L, 0L, actionCollection(),
		       "orientation_menu");
  connect ( orientation, SIGNAL (activated (int)),
	    this, SLOT (slotOrientation(int)) );

  orientation->setItems (orientations);
  
  //TODO -- zoom (maybe remove media from toolbar)
  media =
    new KSelectAction (i18n("Paper &Size"), 0, 0L, 0L,
		       actionCollection(), "media_menu");
  
  connect ( media, SIGNAL (activated (int)),
	    this, SLOT (slotMedia(int)) );



    zoomInAct =
      KStdAction::zoomIn (w,  SLOT(zoomIn() ),
			  actionCollection(), "zoomIn");
    zoomOutAct =
      KStdAction::zoomOut (w,  SLOT(zoomOut() ),
			  actionCollection(), "zoomOut");


    backAct =
      KStdAction::prior (w, SLOT(prevPage() ),
			 actionCollection(), "prevPage");

    forwardAct =
      KStdAction::next (w, SLOT(nextPage() ),
			actionCollection(), "nextPage");

    startAct =
      new KAction(i18n("Go to start"),
		  QIconSet(BarIcon("start", KGVFactory::instance())),
		  CTRL+Key_Home, w, SLOT(goToStart() ), actionCollection(), "goToStart");
    endAct =
      new KAction(i18n("Go to end"),
		  QIconSet(BarIcon("finish", KGVFactory::instance())),
		  CTRL+Key_End, w, SLOT(goToEnd() ), actionCollection(), "goToEnd");
    endDocAct =
      new KAction(i18n("Read down document"),
		  QIconSet(BarIcon("next", KGVFactory::instance())),
		  Key_Space, w, SLOT(readDown() ),
		  actionCollection(), "readDown");
    markAct =
      new KAction(i18n("Toggle this page mark"),
		  QIconSet(BarIcon("flag", KGVFactory::instance())),
		  Key_Enter, w, SLOT(markPage() ), actionCollection(), "markPage");
    gotoAct =
      KStdAction::gotoPage (w, SLOT(goToPage() ),
			    actionCollection(), "goToPage");

    //TODO -- disable entry if there aren't any page names
    //Settings menu
    fancyAct =
      new KToggleAction (i18n("Show Page Names"),
			 0, this, SLOT(slotFancy()), actionCollection(),
			 "fancy_page_labels");
    fancyAct->setChecked (w->areFancyPageLabelsEnabled ());

    //TODO
    // arrows move H/V scroll bars
    // progress bars for conversions (see loadingProgress())

    m_extension = new KGVBrowserExtension( this );

    setXMLFile( "kgv_part.rc" );
    connect ( miniWidget(), SIGNAL (newPageShown()),
	      this, SLOT (slotNewPage()) );
    enableAllActions( false ); // no document to apply the actions to, yet
}

KGVPart::~KGVPart()
{
}

void
KGVPart::enableAllActions( bool enable )
{
  int count = actionCollection()->count();
  for ( int i = 0; i < count; i++ )
    actionCollection()->action( i )->setEnabled( enable );

  media->setItems (miniWidget()->sizeList());
}

bool
KGVPart::openFile()
{
  bool b = w->openFile(m_file);
  enableAllActions( true );
  return b;
}

void
KGVPart::slotFancy()
{
  w->enableFancyPageLabels 
    (fancyAct->isChecked());
}

void
KGVPart::slotNewPage()
{
  media->setCurrentItem (miniWidget()->getSize()-1);
  orientation->setCurrentItem (miniWidget()->getOrientation()-1);
  //TODO -- zoom
}
void
KGVPart::slotOrientation(int id)
{
  miniWidget()->setOrientation (id+1);
}

void
KGVPart::slotMedia(int id)
{
  miniWidget()->setSize (id);
}

KGVBrowserExtension::KGVBrowserExtension( KGVPart *parent ) :
  KParts::BrowserExtension( parent, "KGVBrowserExtension" )
{
}

void
KGVBrowserExtension::print()
{
  ((KGVPart *)parent())->miniWidget()->print();
}




#include "kgv_view.moc"

