/**
 * This is essentially the KGhostview widget stripped down and without all the
 * KTMainWindow dependencies (there were quite a bit with menus, toolbars,
 * etc.. accessed all over the place). It would probably make sense to make
 * that use this in the future (mosfet@kde.org).
 */
 
#ifndef __KGV_MINIWIDGET_H
#define __KGV_MINIWIDGET_H

#include <qsize.h>
#include <qstringlist.h>

#include "kpswidget.h"
#include "print.h"
#include "copyright.h"
#include "marklist.h"

#include <stdlib.h>
#include <math.h>

#include <signal.h>
#ifdef SIGNALRETURNSINT
#define SIGVAL int
#else
#define SIGVAL void
#endif

#include <qwidget.h>
#include <qlabel.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qpushbutton.h>

#include <kurl.h>

class GotoDialog;
class InfoDialog;
class ScrollBox;


class KGVMiniWidget : public QWidget
{
    Q_OBJECT

public:
    KGVMiniWidget( QWidget *parent=0, const char *name=0 );
    ~KGVMiniWidget();

    /**
     * Is a file currently open?
     **/
    bool isFileOpen() {return psfile!=0;}

    /**
     * Open the @em local file @p filename.
     **/
    bool openFile(QString &filename);

    /**
     * Tell what was the original URL requested by the user.
     **/
    void setOriginalURL (const KURL &url);

    /**
     * Might suggest a new width to accomodate the document.
     **/
    QSize sizeHint ();

    /**
     * The pagemark manager.
     **/
     MarkList *markList () { return marklist; }

    /** 
     * Show the mark (aka "page") list.
     **/
    void showMarkList (bool);
    bool isMarkListShown () {return bshowml;}

    /**
     * Enable/disable fancy, document-supplied page labels.
     **/
    void enableFancyPageLabels (bool e=true);
    bool areFancyPageLabelsEnabled () {return bfancypagelabels;}
    /**
     * Write settings to application config file.
     **/
    void writeSettings();

    /**
     * A list of page media (sizes).
     **/
    const QStringList &sizeList () {return medialist;}

    /**
     * 1 - Portrait, 2 - Upside Down, 3 - Landscape, 4 - Seascape
     **/
    void setOrientation (int);
    int getOrientation () {return current_orientation;}

    /**
     * The argument is an index into mediaList()
     **/
    void setSize (int);
    int getSize () {return current_pagemedia;}

public slots:
    /**
     * Save the current document as the @em local file @p filename
     **/
      void saveAs ();


    //void pageActivated( const char * text); // Dutta 16/3/98
    void pageActivated( int pg );	// Dutta 16/3/98
    void scrollDown();
    void scrollUp();
    void scrollRight();
    void scrollLeft();
    void nextPage();
    void prevPage();
    void goToPage();
    void goToPage( int page );
    void goToStart();
    void goToEnd();
    void readDown();
    void print();
    void zoomIn();
    void zoomOut();
    //    void zoom( float zoom_factor );
    void markPage();
    void shrinkWrap();
    /**
     * Redisplay the page if the file has changed on disk.
     **/
    void redisplayChanged();
    void redisplay();
    void info();
    void configureGhostscript();

 protected:
    bool setup();
    void buildTOC(int pagenumber);
    void show_page(int number);
    void build_pagemedia_list();
    void set_magstep(unsigned int new_magstep);
    void magnify(float *dpi, unsigned int magstep);
    void new_file(int number);
    bool same_document_media();
    bool set_new_orientation(int number);
    bool set_new_pagemedia( int number );
    bool set_new_magstep();

    void readSettings();

    void setName();

    QFrame *divider;
    MarkList *marklist;
    ScrollBox *scrollBox;
    KPSWidget *page;

    bool force_pagemedia;
    bool force_orientation;
    int orientation;

    void printStart( int mode, bool reverseOrder, bool toFile,
                     QString printerName, QString spoolerCommmand,
                     QString printerVariable,
                     int pgStart, int pgEnd );

    QString printToFile( QStrList *ml=0L  );
				
    QString printToPrinter( QString printerName,
                            QString spoolerCommand, QString printerVariable,
                            bool allMode, QStrList *ml  );

    void psCopyDoc( FILE *fp, QStrList *ml );


    FILE		*psfile;
    QString 	filename;
    QString		oldfilename;
    int			current_page;
    int 		pages_in_part[10];
    int 		num_parts;
    time_t		mtime;
    struct 		document *doc;
    struct 		document *olddoc;

 signals:
    /**
     * The marklist has been shown(true)/hidden(false).
     **/
    void markListShown (bool);
    /**
     * Emitted when the sizeHint() has been updated.
     *
     * You might want to resize yourself to accomodate.
     **/
    void sizeHintChanged();

    /**
     * Page changed.
     **/
    void newPageShown();
protected:
    void paletteChange( const QPalette & );
    //    void resizeEvent(QResizeEvent *ev);

private:
    QString printerName;
    unsigned int shrink_magsteps, expand_magsteps, magstep,
      current_magstep;
    bool force_document_media;
    int	base_papersize;
    bool toc_text;
    int	toc_length;
    int	toc_entry_length;
    char page_total_label[20];
    char part_total_label[20];
    QString part_string;
    QString page_string;
    QString page_label_text;
    QString part_label_text;
    QString position_label;
    float default_xdpi, default_ydpi;
    int current_llx, current_lly, current_urx, current_ury;
    int current_pagemedia, default_pagemedia, document_media;
    int current_orientation;
    int hintwidth;
    bool bshowml;
    bool bfancypagelabels, bspecialnoupdate;

    KURL origurl;

    InfoDialog *mInfoDialog;
    GotoDialog *mGotoDialog;
    PrintDialog *pd;

    enum DocFormat {PS, PDF};
    DocFormat format;
    QString tmpfile1, tmppdf;
    QStringList medialist;

    bool convertFromPDF();
    int autoOrient(int pagenumber);
};



#endif
