/*
 * katalog.h. Part of the KDE project.
 *
 * Copyright (C) 1999 Waldo Bastian
 *
 */

#ifndef _MAINVIEW_H_
#define _MAINVIEW_H_

#include <qscrollview.h>
#include <qimage.h>
#include <kurl.h>

class Catalog;
class Item;
class ItemViewList;

class MainView : public QScrollView 
{
  Q_OBJECT
  int newX;
  int newY;
  int mRowSize;
  
  Catalog *mCatalog;
public:
  MainView(QWidget * parent=0, const char *name = 0);
  ~MainView();

  /**
   * Catalog
   **/ 
public:
  Catalog *catalog() { return mCatalog; }
  void setCatalog( Catalog *catalog);
public slots:
  void resetCatalog();  

  /**
   * Items
   **/
public:
  void initItems();
  void layoutItems();
  void updateView();
public slots:
  void addItem(Item* newItem);  
  void removeItem(Item *oldItem);

public:
  bool addImage(const KURL &, bool checkForDir = true);
  bool addImage(const QImage &);

protected:
  ItemViewList *mViewList;
  int mColCount;
};

#endif
