/*
 * itemview.cpp. 
 *
 * Copyright (C) 1999 Waldo Bastian
 *
 */

#include "itemview.h"
#include "item.h"
#include "catalog.h"
#include <qpainter.h>
#include <qpopupmenu.h>
#include <klocale.h>
#include <kprocess.h>

#define TN_SIZE QSize(120,100)

ItemView::ItemView(QWidget *parent, Item *item)
 : QFrame(parent), mItem(item), mRMBMenu(0)
{
  setFrameStyle(StyledPanel | Sunken);
  setLineWidth(4);
  setMidLineWidth(2); 
  autoSize();
}

ItemView::~ItemView()
{
   delete mRMBMenu;
}

void
ItemView::autoSize()
{
   int margin = 5;
   Catalog *cat = mItem->catalog();
   int lineSpace = fontMetrics().lineSpacing();
   int h = 0;
   int w = 0;
   if (cat->viewName())
      h += lineSpace;
   if (cat->viewSize())
      h += lineSpace;
   if (cat->viewFilesize())
      h += lineSpace;
 
   if (h) {
      w = 190+margin*2;
   }
   h += (lineSpace/2)*3+margin*2;

   if (w < TN_SIZE.width())
      w = TN_SIZE.width()+margin*8;

   h += TN_SIZE.height()+margin*2;
   resize(w, h);          
}

void
ItemView::paintEvent(QPaintEvent *ev)
{
   QFrame::paintEvent(ev);

   int margin = 5;
   Catalog *cat = mItem->catalog();
   int lineSpace = fontMetrics().lineSpacing();
   int h = 0;
   int w = 0;
   if (cat->viewName())
      h += lineSpace;
   if (cat->viewSize())
      h += lineSpace;
   if (cat->viewFilesize())
      h += lineSpace;
 
  h += (lineSpace/2)*3+margin*2;

  int x = (width() - TN_SIZE.width())/2;
  int y = (height() - h - TN_SIZE.height())/2+margin*2;

  QPainter p(this);
  p.setClipRect(ev->rect());
  p.setPen(foregroundColor());
  p.drawRect( x-margin, y-margin, 
       TN_SIZE.width()+2*margin, TN_SIZE.height()+2*margin);
 
  QPixmap pm = mItem->thumbNail();

  int xOfs = (TN_SIZE.width() - pm.width()) / 2;
  int yOfs = (TN_SIZE.height() - pm.height()) / 2;

  p.drawPixmap( x + xOfs, y + yOfs, pm);

  int textMargin = 10;
  int textBase = height() - h + margin*3 + (lineSpace/2)*2;

  QSize dim = mItem->dimensions();

  if (cat->viewName())
  {
     p.drawText(textMargin, textBase, 
          i18n("Name: %1").arg(mItem->name()));
     textBase += lineSpace;
  }
  if (cat->viewSize())
  {
    p.drawText(textMargin, textBase, 
         i18n("Size: %1 x %2 pixels").arg(dim.width()).arg(dim.height()));
    textBase += lineSpace;
  }
  if (cat->viewFilesize())
  {
    QString fs;
    fs.sprintf("%.1f", mItem->size() /1024.0);
    p.drawText(textMargin, textBase,
         i18n("Filesize: %1 Kb").arg(fs));  
  }
}

void 
ItemView::mousePressEvent( QMouseEvent *e )
{
  QFrame::mousePressEvent( e );
  if (e->button() != RightButton)
     return;
  
  if (!mRMBMenu)
  {
     mRMBMenu = new QPopupMenu();
     mRMBMenu->insertItem( i18n("View"), this, SLOT(slotView()));
     mRMBMenu->insertSeparator(-1);
     mRMBMenu->insertItem( i18n("Delete"), this, SLOT(slotDelete()));
  }
  mRMBMenu->popup(e->globalPos());
}

void
ItemView::slotDelete()
{
  delete mItem; // This will delete us ourselves as well eventually
}

void
ItemView::slotView()
{
  KProcess *kp = new KProcess();
  *kp << "kview";
  *kp << mItem->location();
  kp->start();
}
