#include "miscui.h"

#include <qpainter.h>
#include <qpen.h>

//-----------------------------------------------------------------------------
#define MCB_SIZE   20
#define MCB_MARGIN  2

MultiCheckBox::MultiCheckBox(int val, QWidget *parent, const char *name)
: QWidget(parent, name), _value(val)
{}

QSize MultiCheckBox::sizeHint() const
{ return QSize(MCB_SIZE, MCB_SIZE); }
QSizePolicy MultiCheckBox::sizePolicy() const
{ return QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed); }

void MultiCheckBox::paintEvent(QPaintEvent *)
{
	QRect r(rect().left()+MCB_MARGIN, rect().top()+MCB_MARGIN,
			rect().right()-MCB_MARGIN, rect().bottom()-MCB_MARGIN);
	drawIn(r);
}

void MultiCheckBox::mousePressEvent(QMouseEvent *e)
{
	if (e->button()==LeftButton) {
		if ( modifie() ) {
			repaint();
			emit changed(_value);
		}
	}
}

void MultiCheckBox::setValue(int val)
{
	if ( _value==val ) return;
	_value = val;
	repaint();
}


//-----------------------------------------------------------------------------
MeetingCheckBox::MeetingCheckBox(Type type, bool _serverControl,
								 QWidget *parent, const char *name)
: MultiCheckBox(type, parent, name), serverControl(_serverControl)
{}

void MeetingCheckBox::drawIn(const QRect &r)
{
	QPainter p(this);
	
	// #### a different look when disabled ???
	switch (type()) {
	 case Ready : 
		p.setPen( QPen(green, 3) );
		p.drawEllipse(r);
		break;
	 case Excluded :
		p.setPen( QPen(red, 3) );
		p.drawLine(r.topLeft(), r.bottomRight());
		p.drawLine(r.bottomLeft(), r.topRight());
		break;
	 case NotReady :
		p.setPen( QPen(darkYellow, 3) );
		p.drawEllipse(r);
		break;
	}
}

bool MeetingCheckBox::modifie()
{
	switch (type()) {
	 case Ready : 
		setValue( (serverControl ? Excluded : NotReady) );
		return TRUE;
	 case NotReady : 
		setValue( (serverControl ? Excluded : Ready) );
		return TRUE;
	 case Excluded : 
		if (!serverControl) return FALSE;
		setValue(NotReady);
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
PlayerCheckBox::PlayerCheckBox(Type type, bool _canBeEmpty, bool _acceptAI,
								QWidget *parent, const char *name)
: MultiCheckBox( ((type==Empty && !_canBeEmpty) || (type==AI && !_acceptAI) ? Human : type),
				parent, name),
  canBeEmpty(_canBeEmpty), acceptAI(_acceptAI)
{}

void PlayerCheckBox::drawIn(const QRect &r)
{
	QPainter p(this);
	
	int ew = 2, eh = 2;
    int x = r.size().width()/5;
	int y = r.size().height()/5;
	QRect leye(r.topLeft()  + QPoint(2*x, 2*y)  - QPoint(ew/2, eh/2), QSize(ew, eh));
	QRect reye(r.topRight() + QPoint(-2*x, 2*y) - QPoint(ew/2, eh/2), QSize(ew, eh));
	
	switch (type()) {
	 case Human : 
		p.setPen( QPen(blue, 3) );
		p.drawEllipse(r);
		p.drawEllipse(leye);
		p.drawEllipse(reye);
		break;
	 case AI :
		p.setPen( QPen(blue, 3) );
		p.drawRect(r);
		p.drawEllipse(leye);
		p.drawEllipse(reye);
		break;
	 case Empty :
		p.setPen( QPen(red, 3) );
		p.drawLine(r.topLeft(), r.bottomRight());
		p.drawLine(r.bottomLeft(), r.topRight());
		break;
	}
}

bool PlayerCheckBox::modifie()
{
	switch (type()) {
	 case Human :
		if (acceptAI) setValue(AI);
		else if (canBeEmpty) setValue(Empty);
		else return FALSE;
		return TRUE;
	 case AI :
		setValue( (canBeEmpty ? Empty : Human) );
		return TRUE;
	 case Empty :
		setValue( Human );
		return TRUE;
	}
	return FALSE;
}
