#ifndef __konq_events_h__
#define __konq_events_h__ $Id: konq_events.h,v 1.5 2000/04/10 15:59:22 faure Exp $

#include <kparts/event.h>
#include <qlist.h>

namespace KParts
{
  class ReadOnlyPart;
};

class KFileItem;
typedef QList<KFileItem> KFileItemList;

class KonqURLEnterEvent : public KParts::Event
{
public:
  KonqURLEnterEvent( const QString &url ) : KParts::Event( s_urlEnterEventName ), m_url( url ) {}

  QString url() const { return m_url; }

  static bool test( const QEvent *event ) { return KParts::Event::test( event, s_urlEnterEventName ); }

private:
  static const char *s_urlEnterEventName;

  QString m_url;
};

class KonqFileSelectionEvent : public KParts::Event
{
public:
  KonqFileSelectionEvent( const KFileItemList &selection, KParts::ReadOnlyPart *part ) : KParts::Event( s_fileItemSelectionEventName ), m_selection( selection ), m_part( part ) {}

  KFileItemList selection() const { return m_selection; }
  KParts::ReadOnlyPart *part() const { return m_part; }

  static bool test( const QEvent *event ) { return KParts::Event::test( event, s_fileItemSelectionEventName ); }

private:
  static const char *s_fileItemSelectionEventName;

  KFileItemList m_selection;
  KParts::ReadOnlyPart *m_part;
};

#endif
