/*
   - 

  written 1998 by Alexander Budnik <budnik@linserv.jinr.ru>
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
  */
#ifndef KIMAP_H
#define KIMAP_H

#include <qobject.h>

class KiMap: public QObject {
  Q_OBJECT
 protected:
  QList<QStrList> keysyms[4], keycodes[4];
  QStrList  capssyms[4];
  QString   name;     // the name of the layout, alwais defined
  QString   label;    // layout label, must be set
  QString   locale;   // layout locale, must be set
  QStrList  authors;  // authors of the layout, must be set. How create this?
  QString   language; // language of layout, must be set (or "unknown")
  QString   comment;  // layout comment, may be unset (will be "No comment")
  QString   charset;  // layout charset, may be unset
  bool      hasAltKeys, hasCompose;
  bool      userData, noFile;
  int       numberOfSyms;
 public:
  KiMap(const char*);
  ~KiMap(){}
  friend class KiKbdConfig;
  /*--- public information ---*/
  const QString Name     () const {return name;}
  const QStrList Authors () const {return authors;}
  const QString Label    () const {return label;}
  const QString Locale   () const {return locale;}
  const QString Comment  () const {return comment;}
  const QString Language () const {return language;}
  const QString Charset  () const {return charset;}
  const QString GoodLabel() const;
  const QString Info     () const;
  const bool HasAltKeys  () const {return hasAltKeys;}
  const bool HasCompose  () const {return hasCompose;}
  const bool UserData    () const {return userData;}
  const bool NoFile      () const {return noFile;}
  const unsigned NumberOfSyms() const {return numberOfSyms;}
  const QColor  MapColor () const;
  const QPixmap MapIcon  () const;
  QList<QStrList>& Keysyms(unsigned i) {return keysyms[i];}
  QList<QStrList>& Keycodes(unsigned i){return keycodes[i];}
  QStrList&        Capssyms(unsigned i){return capssyms[i];}
 public slots:
  void noUserDataFile(const QString&){userData = FALSE;}
  void noSystemDataFile(const QString&){noFile = TRUE;}
};
