/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __menus_h__
#define __menus_h__

#include <qlist.h>
#include <qstringlist.h>
#include <qfileinfo.h>
#include <qdir.h>
#include <qintdict.h>
#include <qtimer.h>

#include <qpopupmenu.h>

#include "clientmenu.h"

class KAboutKDE;
class KProcess;

typedef QListIterator<QFileInfo>QFileInfoListIterator;

class KickerClientMenu;

// Base class for file and applnk menus
class PanelMenu : public QPopupMenu
{
  Q_OBJECT;

 public:
  PanelMenu(const QString &startDir, QWidget *parent=0,
            const char *name=0);
  ~PanelMenu(){}
  
  const QString& path() { return(startPath); }
  void setPath(const QString &p) { startPath = p; }
  bool initialized() { return(init); }

 public slots:
  virtual void slotAboutToShow();
  virtual void initialize() = 0;

 protected slots:
  virtual void slotExec(int id) = 0;
  void slotClear();

 protected:
  virtual void hideEvent(QHideEvent *ev);

  bool init;
  int clearDelay;
  QString startPath;
  QTimer t;
};

class PanelAppletMenu : public QPopupMenu
{
  Q_OBJECT;

 public:
  PanelAppletMenu(QWidget *parent=0, const char *name=0);

 protected slots:
  virtual void slotExec(int id);

 private:
  QStringList internalApplets;
};

// Both a file and applnk directory structure browser popupmenu
class PanelBrowserMenu : public PanelMenu
{
  Q_OBJECT;

 public:
  PanelBrowserMenu(QString startDir, bool expandFSTypes=false,
                   bool ignoreEmptyDirs=false, QWidget *parent=0,
                   const char *name=0,
                   int filter = QDir::Hidden | QDir::Dirs | QDir::Files,
                   int sorting = QDir::DirsFirst| QDir::Name);

  void append(const QPixmap &pixmap, const QString &title,
              const QString &filename);
  void append(const QPixmap &smallPixmap, const QPixmap &mediumPixmap,
              const QString &title,
              const QString &filename);
  void append(const QIconSet &iconSet, const QString &title,
              const QString &filename);
  void append(const QPixmap &pixmap, const QString &title,
              PanelBrowserMenu *subMenu);
  void append(const QPixmap &smallPixmap, const QPixmap &mediumPixmap,
              const QString &title,
              PanelBrowserMenu *subMenu);
  void append(const QIconSet &iconSet, const QString &title,
              PanelBrowserMenu *subMenu);


 public slots:
  virtual void initialize();

 protected slots:
  virtual void slotExec(int id);

 protected:
  virtual void mousePressEvent(QMouseEvent *);
  virtual void mouseMoveEvent(QMouseEvent *);

  virtual PanelBrowserMenu* createSubMenu(QString startDir,
					  bool expandFSTypes=false,
                                  bool ignoreEmptyDirs=false, QWidget *parent=0,
                                  const char *name=0,
                                  int filter = QDir::Hidden | QDir::Dirs | QDir::Files,
                                  int sorting = QDir::DirsFirst| QDir::Name);

  QPoint m_pressedPos;
  QStringList fileList;

  unsigned int max;
  bool maxedOut, expandFS, ignoreEmpty;
  QDir::FilterSpec filterSpec;
  QDir::SortSpec sortSpec;
};


// The toplevel menu for the quickbrowser
class PanelQuickBrowser : public PanelMenu
{
  Q_OBJECT;

 public:
  PanelQuickBrowser(QWidget *parent=0, const char *name=0);

 public slots:
  virtual void initialize();

 protected slots:
  virtual void slotExec(int id);

 protected:
  void parseBrowserApplnks(QFileInfoListIterator &it, const QString &title,
                           const QString &pixmap);
  QStringList fileList;
  unsigned int max;
};

class PanelAddAppsBaseMenu : public PanelBrowserMenu
{
  Q_OBJECT;

 public:
  PanelAddAppsBaseMenu(QString startDir, bool expandFSTypes=false,
                       bool ignoreEmptyDirs=false, QWidget *parent=0,
                       const char *name=0,
                       int filter = QDir::Hidden | QDir::Dirs | QDir::Files,
                       int sorting = QDir::DirsFirst| QDir::Name);

 protected slots:
  virtual void slotExec(int id);

 protected:
    virtual PanelBrowserMenu* createSubMenu(QString startDir,
					  bool expandFSTypes=false,
                                          bool ignoreEmptyDirs=false, QWidget *parent=0,
                                          const char *name=0,
                                          int filter = QDir::Hidden | QDir::Dirs | QDir::Files,
                                          int sorting = QDir::DirsFirst| QDir::Name);

};

// Add applications menu
class PanelAddAppsMenu : public PanelAddAppsBaseMenu
{
  Q_OBJECT;

 public:
  PanelAddAppsMenu(QWidget *parent=0, const char *name=0);
  ~PanelAddAppsMenu(){;}

  virtual void initialize();
};

// Menu for the "Recent Documents". It mostly just re-initializes when shown.
class PanelRecentMenu : public PanelBrowserMenu
{
  Q_OBJECT;

 public:
  PanelRecentMenu(QWidget *parent=0, const char *name=0);
  virtual void initialize();

 protected slots:
  void slotClearHistory();
};

// The button operations menu (usually right click)
class PanelAppletOpMenu : public QPopupMenu
{
 public:
  enum OpButton{Move = 9900, Remove = 9901, Help = 9902, About = 9903, Preferences = 9904 };
  PanelAppletOpMenu(int actions, QWidget *parent=0, const char *name=0);
};

// The directory dropped menu
class PanelDirDropMenu : public QPopupMenu
{
 public:
  enum OpButton{Url=1, Browser};
  PanelDirDropMenu(QWidget *parent=0, const char *name=0);
};

class PanelOpMenu : public QPopupMenu
{
  Q_OBJECT;

 public:
  PanelOpMenu(QWidget *parent=0, const char *name=0);

 protected slots:
  void slotSizeSmall();
  void slotSizeNormal();
  void slotSizeLarge();
  void slotConfigure();
  void slotRestart();
  void slotRestartDontAsk();
  void slotAddKMenu();
  void slotAddWindowList();
  void slotAddQuickBrowser();
  void slotAddNonKDEApp();
};

class PanelWindowListMenu : public QPopupMenu
{
  Q_OBJECT;

 public:
  PanelWindowListMenu(QWidget *parent=0, const char *name=0);

  void init();

 protected slots:
  virtual void slotExec(int id);
};

#endif // __menus_h__
