#ifndef _DESKTOP_H
#define _DESKTOP_H

#include <qwidget.h>
#include <qlist.h>
#include <kwinmodule.h>

class QPixmap;

class KPagerDesktop : public QWidget
{
  Q_OBJECT

    struct WindowData
    {
      WId wid;
      QRect rect;
      /**
	* True if it's the active window (the one with the focus)
	*/
      bool active;
      /**
       * True if the mouse is over the pager representation
       */
      bool hilight;
    };
protected:
    void fillWinList();  
    /**
     * Fills the windowData struct with all the available info for the
     * window with WId id. If w is not 0L, it fills the given struct and
     * returns it, if it's 0 it creates a new struct and returns it. 
     */
    virtual WindowData *winData(WId id, WindowData *w=0L);

    /**
     * Delete pointers used in the WindowData struct, the WindowData struct, and
     * removes it from the list of windows (winList). It does nothing
     * in KPagerDesktop, but it may do something in classes that
     * inherit from this one.
     *
     */
    virtual void removeWin( WindowData *wd);
    
    /**
     * Returns the windowData (or inherited) struct associated with
     * window id
     */
    WindowData *findWinData(WId id);
    
    /**
     * These methods describe the rectangle in which the real desktop is
     * painted (without the 2 pixels border).
     */
    virtual int deskX() { return 2; }; 
    virtual int deskY() { return 2; };
    virtual int deskWidth() { return width()-4; };
    virtual int deskHeight() { return height()-4; };

    /**
     * Translate points and rectangles from screen coordinates to pager coords
     */
    void scr2Pager(QRect *r);
    void scr2Pager(QPoint *p); // Not implemented yet
    void scr2Pager(int *x,int *y); // Not implemented yet
    void pager2Scr(int *x,int *y);
    WindowData *windowAtPosition(const QPoint &p, QPoint *internalpos=0L);

public:
    KPagerDesktop(int desk, class KWinModule *kwinmod, QWidget *parent=0);
    virtual ~KPagerDesktop();

    /**
      * This method must be call just after the constructor, in order to be
      * able to call virtual methods for initialization
      */
    void init(void);

public slots:
  /**
   * Sets this desktop as the current one, so that it gets an highlighted frame
   */
    void setCurrentDesktop(bool current);

/*    void windowAdd(WId);
    void windowRemove(WId);
    */
    void windowChange( WId id );
  
signals:
    void deskChangeRequest(int desk);

    void moveWindowRequest(int desk);
    
    /**
     * Request to show a popup menu for window wid at position pos
     */
    void showPopupMenu(WId wid, QPoint pos);

protected:
    virtual QPixmap *paintWindow(const WindowData *wd, QPoint *pos);
    virtual void paintEvent(QPaintEvent *ev);
    virtual void mousePressEvent(QMouseEvent *ev);
    virtual void mouseMoveEvent(QMouseEvent *ev);
    virtual void dragEnterEvent(QDragEnterEvent *ev);
    virtual void dragMoveEvent(QDragMoveEvent *ev);
    virtual void dropEvent(QDropEvent *ev);
    void startDrag(const QPoint &pos);
    int deskNum;
    int isCurrentDesktop;
    KWinModule *kWinModule;
    QList <WindowData> winList;
};

#endif
