/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qpainter.h>

#include <kwinmodule.h>
#include <kglobal.h>
#include <klocale.h>

#include <X11/Xlib.h>

#include "../../internalapplet.h"
#include "dockapplet.h"

KWinModule* kwin_module;

extern "C"
{
    InternalApplet* init(QWidget *parent, KWinModule *module)
    {
        kwin_module = module;
	    //KGlobal::locale()->insertCatalogue("kdockapplet");
        return new DockAreaApplet(parent, "kdockapplet");
    }
}

KXEmbed::KXEmbed(QWidget *parent, const char *name, WFlags f)
    : QXEmbed(parent, name, f)
{}

KXEmbed::~KXEmbed()
{
    // This prevents ~QXEmbed from destroying the window.
    WId id = embeddedWinId();
    XEvent e;
    e.type = DestroyNotify;
    e.xdestroywindow.window = id;
    QXEmbed::x11Event(&e);
    
    XReparentWindow(qt_xdisplay(), id, qt_xrootwin(), 0, 0);
}
    

DockAreaApplet::DockAreaApplet( QWidget* parent, const char* name )
    : InternalApplet( parent, name )
{
   connect( kwin_module, SIGNAL( dockWindowAdd(WId) ), this, SLOT( dockWindowAdd(WId) ) );
   connect( kwin_module, SIGNAL( dockWindowRemove(WId) ), this, SLOT( updateDockWindows() ) );

   m_Docks.setAutoDelete(true);

   // register existing dock windows
   const QValueList<WId> dockWindows = kwin_module->dockWindows();
   QValueList<WId>::ConstIterator it;
   for ( it=dockWindows.begin(); it!=dockWindows.end(); ++it )
      dockWindowAdd( *it );
}

DockAreaApplet::~DockAreaApplet()
{
    m_Docks.clear();
}

void DockAreaApplet::paintEvent( QPaintEvent* )
{
    QPainter p( this );
    style().drawPanel( &p, 0, 0, width(), height(), colorGroup(), TRUE );
}

int DockAreaApplet::widthForHeight(int)
{
  int ret;

  if ( height() < 52 )
    ret = m_Docks.count()*24 + 8;
  else
    ret = ((m_Docks.count()+1) * 12) + 8;

  return (ret > 56) ? ret : 56;
}

int DockAreaApplet::heightForWidth(int)
{
  int ret;

  if ( width() < 52 )
    return m_Docks.count()*24 + 8;
  else
    return ((m_Docks.count()+1) * 12) + 8;

  return (ret > 56) ? ret : 56;
}

void DockAreaApplet::resizeEvent( QResizeEvent* )
{
    layoutDockingArea();
}

void DockAreaApplet::dockWindowAdd( WId w )
{
    KXEmbed *emb = new KXEmbed(this);
    connect(emb, SIGNAL(embeddedWindowDestroyed()), SLOT(updateDockWindows()));
    m_Docks.append(emb);

    emb->embed(w);
    emb->resize(24, 24);
    emb->show();

    layoutDockingArea();
}

void DockAreaApplet::updateDockWindows()
{
    KXEmbed *emb = m_Docks.first();
    while ((emb = m_Docks.current()) != 0L) {
	WId wid = emb->embeddedWinId();
	if ((wid == 0) || !kwin_module->dockWindows().contains(wid))
	    m_Docks.remove(emb);
	else
	    m_Docks.next();
    }
    layoutDockingArea();
}
	
void DockAreaApplet::layoutDockingArea()
{
    if (m_Docks.count() == 0)
	  return;

    int i;

    KXEmbed *emb;
    int col = 0;
    if (orientation() == Vertical) {
      i = 0;
      for (emb = m_Docks.first(); emb != 0L; emb = m_Docks.next()) {
        if ( (m_Docks.count() == 1) || width() < 52 )
            emb->move(width() / 2 - 14, 2 + i*24);
        else {
            emb->move(((i%2) == 0) ? 2 : width() - 26, 2 + col*24);
            if ( (i%2) != 0 )
                ++col;
        }
        i++;
      }
    }
    else {
      i = 0;
      for (emb = m_Docks.first(); emb != 0L; emb = m_Docks.next()) {
        if ( (m_Docks.count() == 1) || height() < 52 )
            emb->move(2 + i*24, height() / 2 - 14);
        else {
            emb->move(2 + col*24, ((i%2) == 0) ? 2 : height() - 26);
            if ( (i%2) != 0 )
                ++col;
        }
        i++;
      }
    }
    updateGeometry();
    show();
}

template class QList<KXEmbed>;

