/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __internalapplet_h__
#define __internalapplet_h__

#include <qframe.h>

/**
 * Inline class to emulate an applet for internal applets.
 */
class InternalApplet : public QFrame
{
  Q_OBJECT;

public:
  enum Actions { About = 1, Help = 2, Preferences = 4 };
  enum Flags { Stretch = 1, TopLevel = 2 };
  enum Position{Left=0, Right, Top, Bottom};

  InternalApplet(QWidget *parent, const char *name, WFlags f=0)
    : QFrame(parent, name, f)
    , _actions(0)
	, _flags(0)
    {
        setFrameStyle(NoFrame);
        QPalette pal(palette());
        if(pal.active().mid() != pal.inactive().mid()){
            pal.setInactive(pal.active());
            setPalette(pal);
        }
    }
  
  void setActions(int a) { _actions = a; emit sigActionsChanged(); }
  int actions(){ return _actions; }

  void setFlags(int f) { _flags = f; emit sigFlagsChanged(); }
  int flags(){ return _flags; }

  virtual int widthForHeight(int h) { return h; }
  virtual int heightForWidth(int w) { return w; }

  virtual void about() {}
  virtual void help() {}
  virtual void preferences() {}

  void updateLayout() { emit sigUpdateLayout(); }

  Orientation orientation() const { return _orient; }
  Position position() const { return _pos; }

  void setPosition(Position p)
    {
      _pos = p;
      resizeEvent(0);
    }
  void setOrientation(Orientation o)
    {
      _orient = o;
      resizeEvent(0);
    }

 signals:
  void sigUpdateLayout();
  void sigActionsChanged();
  void sigFlagsChanged();

private:
  int _actions, _flags;
  Orientation _orient;
  Position _pos;
};

#endif
