/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qpainter.h>
#include <qapp.h>
#include <qstyle.h>

#include <kglobal.h>
#include <kconfig.h>

#include "hidebutton.h"
#include "hidebutton.moc"
#include "menus.h"

const int hb_arrow = 8;

HideButton::HideButton(Position pos, QWidget *parent, const char *name)
  : QButton(parent, name)
  , _highlight(false)
  , _dohighlight(true)
  , _pos(pos) {}

void HideButton::configure()
{
  KConfig *config = KGlobal::config();
  config->setGroup("panel");
  _dohighlight = config->readBoolEntry("HighlightHideButtons", true);
  repaint();
}

void HideButton::setPosition(Position pos)
{
  _pos = pos;
  repaint();
}

void HideButton::enterEvent(QEvent *)
{
  _highlight = true;
  repaint();
}

void HideButton::leaveEvent(QEvent *)
{
  _highlight = false;
  repaint();
}

void HideButton::paintEvent(QPaintEvent *e)
{
  QWidget::paintEvent(e);

  bool hl = _highlight;
  if(!_dohighlight) hl = false;

  QPainter p(this);
  p.setFont(font());
  if(!isDown()){
    if(!hl)
      p.fillRect(rect(), colorGroup().brush(QColorGroup::Background));
    else
      p.fillRect(rect(), colorGroup().brush(QColorGroup::Light));
    p.setPen(colorGroup().light());
    p.drawLine(0, 0, width()-1, 0);
    p.drawLine(0, 0, 0, height()-1);
    p.setPen(Qt::black);
    p.drawLine(0, height()-1, width()-1, height()-1);
    p.drawLine(width()-1, 0, width()-1, height()-1);
  }
  else{
    p.fillRect(rect(), colorGroup().brush(QColorGroup::Mid));
    p.setPen(Qt::black);
    p.drawLine(0, 0, width()-1, 0);
    p.drawLine(0, 0, 0, height()-1);
    p.setPen(colorGroup().light());
    p.drawLine(0, height()-1, width()-1, height()-1);
    p.drawLine(width()-1, 0, width()-1, height()-1);
  }

  if(width() < 10 || height() < 10)
    return; // don't draw arrows if we are to small

  int d = 0;
  if (isDown()) d = 1;

  if(_pos == Bottom)
    QApplication::style().drawArrow(&p, Qt::DownArrow, isDown(),
                                    (width()-hb_arrow)/2 +d, (height()-hb_arrow)/2 +d,
                                    hb_arrow, hb_arrow, colorGroup(), true);
  else if (_pos == Top)
    QApplication::style().drawArrow(&p, Qt::UpArrow, isDown(),
                                    (width()-hb_arrow)/2 +d, (height()-hb_arrow)/2 +d,
                                    hb_arrow, hb_arrow, colorGroup(), true);
  else if (_pos == Left)
    QApplication::style().drawArrow(&p, Qt::LeftArrow, isDown(),
                                    (width()-hb_arrow)/2 +d, (height()-hb_arrow)/2 +d,
                                    hb_arrow, hb_arrow, colorGroup(), true);
  else
    QApplication::style().drawArrow(&p, Qt::RightArrow, isDown(),
                                    (width()-hb_arrow)/2 +d, (height()-hb_arrow)/2 +d,
                                    hb_arrow, hb_arrow, colorGroup(), true);
}
