#include <iostream>


#include <kinstance.h>
#include <kglobal.h>
#include <kstddirs.h>
#include <kcmdlineargs.h>
#include <klocale.h>


#include <qstringlist.h>


#include "checker.h"


int main(int argc, char *argv[])
{
  KInstance instance("kappfinder_install");
  
  if (argc != 2)
    {
      cerr << "Usage: kappfiner_install $directory" << endl;
      return -1;
    }
 
  QStringList _templates = KGlobal::dirs()->findAllResources("data", "kappfinder/apps/*.desktop", true);

  QString dir = QString(argv[1])+"/";

  QStringList::Iterator it;
  for (it = _templates.begin(); it != _templates.end(); ++it)
    checkDesktopFile(*it, dir);

  decorateDirs(dir);
}
