/***************************************************************************
                          kdltooltip.cpp  -  description
                             -------------------
    begin                : Tue Oct 5 1999
    copyright            : (C) 1999 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

#include <qrect.h>
#include <qscrollbar.h>
#include <qheader.h>
#include "kndraglist.h"
#include "kdltooltip.h"
#include "minmax.h"

KDLToolTip::KDLToolTip (K2ListView *parent, QToolTipGroup* group)
  : QToolTip(parent, group),
	mParent (parent)
{
}

KDLToolTip::~KDLToolTip()
{
}

void KDLToolTip::maybeTip (const QPoint& p)
{
  if (!mParent->displayToolTips())
	return;

  QString text;
  QRect rect;

  const QRect vert = mParent->verticalScrollBar()->geometry();
  const QRect horiz = mParent->horizontalScrollBar()->geometry();

  if (vert.contains(p))
	{
	  rect = vert;
	  
	  if (!mParent->commonToolTips())
		text = mParent->verticalScrollBarTip();
	  else
		text = mParent->tooltip();
	}
  else if (horiz.contains(p))
	{
	  rect = horiz;
	  if (!mParent->commonToolTips())
		text = mParent->horizontalScrollBarTip();
	  else
		text = mParent->tooltip();
	  
	}
  else
	{ 
	  QPoint rp = mParent->viewport()->mapFromParent (p);
	  QListViewItem* i = mParent->itemAt (rp);
	  K2ListViewItem* item = dynamic_cast<K2ListViewItem*> (i);
	  
	  if (item)
		{
		  rect = mParent->itemRect (i);
		  rect.moveTopLeft (mParent->viewport()->mapToParent (rect.topLeft()));
		  text = item->tooltip();
		}
	  else
		{
		  rect = mParent->header()->geometry();
		  if (!rect.contains (p))
			{
			  rect = mParent->rect();
			}
		  
		  text = mParent->tooltip();
		}
	}

  if (!text.isEmpty())
	tip (rect, text);
}
