/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include "partitioninfo.h"


PartitionInfo::PartitionInfo(const QString& partid,
			     ushort major, ushort minor,
                             const QString& mountp,
                             ulong blocks, ulong total, ulong used,
                             ulong avail) : _partid(partid),
                                            _mountp(mountp),
                             		    _major(major),
                                            _minor(minor),
                                            _blocks(blocks),
                                            _total(total),
                                            _used(used),
                                            _avail(avail)
{
  debug("Partition /dev/%s",    _partid.ascii());
  debug("\tmajor number = %u",  _major);
  debug("\tminor number = %u",  _minor);
  debug("\tmountpoint   = %s",  _mountp.ascii());
  debug("\ttotal size   = %lu", _total);
  debug("\tused         = %lu", _used);
  debug("\tavailable    = %lu", _avail);
}
