/////////////////////////////////////////////////////////////////////////
// $Id: packageDisplay.h,v 1.7 2000/05/02 15:01:39 toivo Exp $	
// File  : packageDisplay.h
// Author: Damyan Pepper
// Author: Toivo Pedaste
//
// This widget is used to display information and the file list of a
// package.
//
// Package information will be displayed using (another) sub-widget
// that is inherited from a QTableView.
//
// The file list will be displayed using a tree list.
//
// The widget is mainly a QTabDialog with two tabs: Info and FileList.
// The Info tab is the default one.
//
// It may prove that the tab dialog idea doesn't work. Something else
// will have to be done in that case!!!
/////////////////////////////////////////////////////////////////////////

#ifndef PACKAGEDISPLAY_H
#define PACKAGEDISPLAY_H
#include "../config.h"

// Qt Headers
#include <qframe.h>
#include <qtabbar.h>
#include <qtabwidget.h>
#include <qvbox.h>
 

class packagePropertiesWidget;
class packageInfo;
class KListView;
class QListViewItem;

class packageDisplayWidget : public QTabWidget
{
  Q_OBJECT;

  ///////////// METHODS ------------------------------------------------------
public:
  packageDisplayWidget(QWidget *parent=0, const char *name=0);
  // Constructor

  ~packageDisplayWidget();
  // Destructor

  void noPackage();
  // clear package display in right panel

private:
  void setupWidgets();
  // This sets up the sub-widgets

  void updateFileList();
  // This updates the file list to match that found with the currently
  // selected package
  
  ///////////// SLOTS --------------------------------------------------------
public slots:
  void changePackage(packageInfo *p);

  void tabSelected(const QString &);

  void openBinding(QListViewItem *);

  ///////////// SIGNALS ------------------------------------------------------

  ///////////// DATA ---------------------------------------------------------
private:
  packageInfo *package;
  // the currently selected package

  QTabWidget *tabbar;
  // The tab bar

  QVBox *proptab, *fltab;

  KListView *fileList;
  // This holds the file list (and is used as a page on the tab dialog)

  QPixmap tick, cross, question, *blank;
  // The pixmaps for the filelist

  packagePropertiesWidget *packageProperties;
  // This displays the package properties (and is used as a page on the
  // tab dialog)

  bool initList;
  // True is file list has been initialised
};
#endif
