//////////////////////////////////////////////////////////////         
//      $Id: kplview.cpp,v 1.6 2000/05/02 15:01:38 toivo Exp $ 
//
// Author: Toivo Pedaste
//
#include "../config.h"
#include <qpixmap.h>

// kpackage.headers
#include "kpackage.h"
#include "pkgInterface.h"
#include "packageInfo.h"
#include "managementWidget.h"
#include "kplview.h"

#define MPOS  1

KPQListView::KPQListView( QWidget *parent, const char * name  ) :
KListView (parent,  name )
{
  markPkg = 0;
}

void KPQListView::clear()
{
  markPkg = 0;
  KListView::clear();
}

KPLVItem *KPQListView::firstChild()
{
  return  (KPLVItem *)KListView::firstChild();
}

KPLVItem *KPQListView::currentItem()
{
  return  (KPLVItem *)KListView::currentItem();
}

void KPQListView::contentsMousePressEvent ( QMouseEvent * e )
{
  if (e->button() == LeftButton) {
    if (inMark(e->x())) {
      QPoint vp = contentsToViewport(e->pos());
      KPLVItem *i = ( KPLVItem *)itemAt( vp );
      if (i && i->childCount() == 0) {   
	if (e->state() == ShiftButton) {
	  if (i->childCount() == 0) 
	    i->setMark(true);
	  KPLVItem *item = i;
	  while ((item = (KPLVItem *)item->itemAbove()) && !item->marked) {;}
	  if (item) {
	    item = i;
	    while ((item = (KPLVItem *)item->itemAbove()) && !item->marked) {
	      if (item->childCount() == 0) 
		item->setMark(true);
	    }
	  } else {
	    item = i;
	    while ((item = (KPLVItem *)item->itemBelow()) && !item->marked) {;}
	    if (item) {
	      item = i;
	      while ((item = (KPLVItem *)item->itemBelow()) && !item->marked) {
		if (item->childCount() == 0) 
		  item->setMark(true);
	      }
	    }
	  }
	} else {
	  i->toggleMark();
	}
      } else 
	KListView::contentsMousePressEvent (e);
    } else 
      KListView::contentsMousePressEvent (e);
  }
}
 
bool KPQListView::inMark(int x) {
  int st = 0;
  int i;

  for (i = 0; i < MPOS; i++)
    st += columnWidth(i);

   return (x >= st && x <= st + columnWidth(MPOS));
}

//////////////////////////////////////////////////////////////////////////////
KPLVItem::KPLVItem( QListViewItem *parent, packageInfo* pinfo,
                  const QPixmap& thePixmap,
                  const char * label1, const char * label2 ,
                  const char * label3 , const char * label4 ,
                  const char * label5 , const char * label6 ,
                  const char * label7 , const char * label8 
 
) :  QListViewItem(parent, label1, label2, label3, label4, label5,
                label6, label7, label8)
{
  info = pinfo;
  marked = false;
  setPixmap(0, thePixmap);
  if (label2)
    setPixmap(1,info->interface->markUnInst);
}
 
KPLVItem::KPLVItem( KListView *parent, packageInfo* pinfo,
                  const QPixmap& thePixmap,
                  const char * label1, const char * label2 ,
                  const char * label3 , const char * label4 ,
                  const char * label5 , const char * label6 ,
                  const char * label7 , const char * label8 
) :  QListViewItem(parent, label1, label2, label3, label4, label5,
                label6, label7, label8)
{
  info = pinfo;
  marked = false;
  setPixmap(0, thePixmap);
  if (label2)
    setPixmap(1,info->interface->markUnInst);
}

KPLVItem *KPLVItem::firstChild()
{
  return  (KPLVItem *)QListViewItem::firstChild();
}

KPLVItem *KPLVItem::nextSibling()
{
  return  (KPLVItem *)QListViewItem::nextSibling();
}

void KPLVItem::toggleMark() 
{
  marked = ! marked;
  if (marked)
    setPixmap(1,info->interface->markInst);
  else
    setPixmap(1,info->interface->markUnInst);
}

void KPLVItem::setMark(bool mark) 
{
  marked = mark;
  if (mark)
    setPixmap(1,info->interface->markInst);
  else
    setPixmap(1,info->interface->markUnInst);
}

void KPLVItem::hide() 
{
  setHeight(0);
}

void KPLVItem::show() 
{
  setup();
}

