//////////////////////////////////////////////////////////////////////
//      $Id: kpackage.cpp,v 1.45 2000/05/28 14:41:17 toivo Exp $ 
// File  : kpackage.cpp
// Author: Damyan Pepper
//         Toivo Pedaste
//
// See kpackage.h for more information.
//////////////////////////////////////////////////////////////////////

#include "../config.h"
extern "C"
{
#include <time.h>
}  
#include <unistd.h>

#include <qdir.h>
#include <kurl.h>
#include <kapp.h>
#include <kaccel.h>
#include <kkeydialog.h>
#include <klocale.h>
#include <klineeditdlg.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kaccelmenu.h>
#include <kstdaction.h>
#include <kedittoolbar.h>
#include <kmimemagic.h>

#include "kpackage.h"
#include "pkgInterface.h"
#include "aboutDialog.h"
#include "managementWidget.h"
#include "installationWidget.h"
#include "pkguninstallDialog.h"
#include "pkgInterface.h"
#include "kio.h"
#include "findf.h"
#include "search.h"
#include "options.h"
#include "cache.h"
#include <qdragobject.h>

extern Params *params;
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
KPKG::KPKG(KConfig *_config, const char *name) 
  : KTMainWindow(name)
{
  kpackage = new KPACKAGE(_config,this);
  //  kpackage->show();
  setView(kpackage);

  config =  kapp->config();
  config->setGroup("Kpackage");

  kpackage->management->readPSeparator();

  // Get a nice default size
  resize(600,400);

  setupMenu();
  disableNext();
  disablePrevious();

  optiondialog = new Options(0, "optionsdialog");

  prop_restart = false;


  int width, height;
  width = config->readNumEntry("Width", 760);
  height = config->readNumEntry("Height", 540);

  if( width < minimumSize().width() ) {
    width = minimumSize().width();
  }
  if( height < minimumSize().height() ) {
    height = minimumSize().height();
  }

  resize(width, height);

}

// Destructor
KPKG::~KPKG()
{
  //   object deletion - slows down exit
  //    delete filemenu;
  //    delete helpmenu;
  //    delete kp; 
  //    delete options; 
  //    delete optiondialog; 
  //    delete caches;
}

// Set up the menu

void KPKG::setupMenu()
{


  keys = new KAccel(this);

  pack_open = KStdAction::open(kpackage, SLOT(fileOpen()),
			  actionCollection());
  pack_open->plugAccel(keys);

  recent = KStdAction::openRecent(this, SLOT(openRecent(const KURL&)),
				  actionCollection());
  recent->loadEntries( config );

 pack_find = new KAction( i18n("Find &Package"), "find", 
		       KStdAccel::key(KStdAccel::Find), kpackage,
		       SLOT(find()), actionCollection(), "pack_find");
  pack_find->plugAccel(keys);

  pack_findf = new KAction( i18n("Find &File"), "findf", 
		       0, kpackage,
		       SLOT(findf()), actionCollection(), "pack_findf");
  pack_findf->plugAccel(keys);

  kpack_reload = new KAction( i18n("&Reload"), "reload", 
		       KStdAccel::key(KStdAccel::Reload), kpackage,
		       SLOT(reload()), actionCollection(), "kpack_reload");
  kpack_reload->plugAccel(keys);

  (void) KStdAction::quit(kpackage, SLOT(fileQuit()),
			  actionCollection())->plugAccel(keys);

  pack_prev = KStdAction::back(kpackage->management, SLOT(previous()),
			  actionCollection(),"pack_prev");
  pack_prev->plugAccel(keys);

  pack_next = KStdAction::forward(kpackage->management, SLOT(next()),
			     actionCollection(),"pack_next");
  pack_next->plugAccel(keys);

  (void) (new KAction( i18n("&Expand Tree"), "ftout", 
		       0, kpackage,
		       SLOT(expandTree()), actionCollection(), "kpack_expand"))->plugAccel(keys);

  (void) (new KAction( i18n("&Collapse Tree"), "ftin", 
		       0, kpackage,
		       SLOT(collapseTree()), actionCollection(), "kpack_collapse"))->plugAccel(keys);

  (void) (new KAction( i18n("Clear &Marked"), 0, 
		       0, kpackage,
		       SLOT(clearMarked()), actionCollection(), "kpack_clear"))->plugAccel(keys);

  KStdAction::showToolbar( this, SLOT(toggleToolBar()), actionCollection());

  KStdAction::configureToolbars( this, SLOT(configureToolBars()),
				 actionCollection())->plugAccel(keys);

  KStdAction::saveOptions( this, SLOT(saveSettings()), actionCollection())->plugAccel(keys);

  KStdAction::keyBindings( this, SLOT(setKeys()), actionCollection())->plugAccel(keys);

  (void) (new KAction( i18n("&Options..."), 0, 
		       0, this,
		       SLOT(setOptions()), actionCollection(), "kpack_options"))->plugAccel(keys);

  int i;
  QString iloc, loc;
  for (i = 0; i < kpinterfaceN; i++) {
    if (kpinterface[i]->locatedialog) {
      iloc = i18n("Location &%1...").arg(kpinterface[i]->head);
      loc = QString("loc_%1").arg(i);
      (void) (new KAction( iloc, 0, 
			   0, kpinterface[i],
			   SLOT(setLocation()), actionCollection(), loc))->plugAccel(keys);
    }
  }

  (void) (new KAction( i18n("Clear package &Directory cache"), 0, 
		       0, this,
		       SLOT(clearDCache()), actionCollection(), "clear_dcache"))->plugAccel(keys);

  (void) (new KAction( i18n("Clear &Package cache"), 0, 
		       0, this,
		       SLOT(clearPCache()), actionCollection(), "clear_pcache"))->plugAccel(keys);

  int toolPos = config->readNumEntry("ToolBarPos",KToolBar::Left);
  int iconText = config->readNumEntry("IconText");
  int iconSize = config->readNumEntry("IconSize",0);

  keys->readSettings();
  urlList.setAutoDelete(TRUE);
  createGUI();

  toolBar()->setBarPos((KToolBar::BarPosition)toolPos);
  toolBar()->setIconText((KToolBar::IconText)iconText);
  toolBar()->setIconSize(iconSize);
}

void KPKG::disableMenu()
{
  pack_open->setEnabled(false);
  pack_find->setEnabled(false);
  pack_findf->setEnabled(false);
  kpack_reload->setEnabled(false);
  recent->setEnabled(false);
}

void KPKG::enableMenu()
{
  pack_open->setEnabled(true);
  pack_find->setEnabled(true);
  pack_findf->setEnabled(true);
  kpack_reload->setEnabled(true);
  recent->setEnabled(true);
}

void KPKG::disableNext() {
  pack_next->setEnabled(false);
}
  
void KPKG::enableNext() {
  pack_next->setEnabled(true);
}
  
void KPKG::disablePrevious() {
  pack_prev->setEnabled(false);
}
  
void KPKG::enablePrevious() {
  pack_prev->setEnabled(true);
}
  
void KPKG::openRecent(const KURL& url){
  kpackage->openNetFile( url.url());
}

void KPKG::add_recent_file(const char* newfile){

  KURL url = KURL(newfile);

  recent->addURL( url );
}

void KPKG::toggleToolBar() {
  if(toolBar()->isVisible())
    toolBar()->hide();
  else
    toolBar()->show();
}
	
void  KPKG::configureToolBars() {
  KEditToolbar dlg(actionCollection());
  if (dlg.exec())
    createGUI();
}

void KPKG::writeSettings(){

  kpackage->management->writePSeparator();

  KConfig *config = kapp->config();

  config->setGroup("Kpackage");

  config->writeEntry("Width", width());
  config->writeEntry("Height", height());
  config->writeEntry( "ToolBar", hide_toolbar ? "off" : "on" );

  // Bars created floating don't work
  if (toolBar()->barPos() == KToolBar::Floating)
    config->writeEntry("ToolBarPos", (int)KToolBar::Left );
  else
    config->writeEntry("ToolBarPos", (int) toolBar()->barPos() );
  config->writeEntry("IconText", (int) toolBar()->iconText() );
  config->writeEntry("IconSize", (int) toolBar()->iconSize() );

  recent->saveEntries( config );

  kpackage->management->writeTreePos();
  kpackage->management->writeTreeType();

  keys->writeSettings();

  config->sync();
}

void KPKG::setOptions(){
  optiondialog->restore();
}

void KPKG::setKeys(){
  KKeyDialog::configureKeys( keys ); 
}

void KPKG::saveSettings(){
  writeSettings();
}

void KPKG::clearPCache(){
  cacheObj::clearPCache();
}

void KPKG::clearDCache(){
  cacheObj::clearDCache();
}

void KPKG::saveProperties(KConfig *config )
{
    config->writeEntry("Name", kpackage->save_url);
}


void KPKG::readProperties(KConfig *config)
{
    QString entry = config->readEntry("Name"); // no default
    if (entry.isNull())
	return;
    kpackage->openNetFile(entry.data());
    prop_restart = true;
}

void KPKG::closeEvent ( QCloseEvent *) {
    kpackage->fileQuit();
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

KPACKAGE::KPACKAGE(KConfig *_config, QWidget *parent, const char *name) 
  : QWidget(parent,name)
{

  // Save copy of config
  config = _config;

  setAcceptDrops(true);
  // Setup the mode widgets
  setupModeWidgets();

  // Setup the status bar
  setupStatusBar();

  file_dialog = NULL;
  findialog = NULL;
  srchdialog = NULL;  
}

// Destructor
KPACKAGE::~KPACKAGE()
{
  destroyModeWidgets();
  delete status;
  delete processProgress;
}

// resize event -- arrange the widgets
void KPACKAGE::resizeEvent(QResizeEvent *re)
{
  re = re;			// prevent warning
  arrangeWidgets();
}

// Set up the mode widgets
void KPACKAGE::setupModeWidgets()
{ 
  management = new managementWidget(this);

  for (int i = 0; i < kpinterfaceN; i++) {

    kpinterface[i]->installation =
      new installationWidget(this, kpinterface[i]);
    connect(kpinterface[i]->installation,
	    SIGNAL(finished(int, pkgInterface *,int)),
	    SLOT(modeFinished(int, pkgInterface *,int)));

    kpinterface[i]->uninstallation =
      new pkguninstallDialog(kpinterface[i]->inituninstallOptions());
    kpinterface[i]->uninstallationMult =
      new pkguninstallDialogMult(kpinterface[i]->inituninstallOptions());
    kpinterface[i]->installationMult =
      new pkginstallDialogMult(kpinterface[i]->initinstallOptions());
  }
}

// destroy the mode widgets
void KPACKAGE::destroyModeWidgets()
{
  delete management;
  for (int i = 0; i < kpinterfaceN; i++) {
    delete kpinterface[i]->installation;
    delete kpinterface[i]->uninstallation;
  }
}


// Set up the status bar
void KPACKAGE::setupStatusBar()
{
  statusbar = new QFrame(this);
  statusbar->setFrameStyle(QFrame::Raised | QFrame::Panel);
  processProgress = new KProgress(0,100,100,KProgress::Horizontal,statusbar);
  processProgress->setBarStyle(KProgress::Solid);
  processProgress->setTextEnabled(FALSE);

  status = new QLabel(i18n("Management Mode"), statusbar);
  status->setFont(QFont("Helvetica",10, QFont::Normal));
}
  
// Arrange the widgets nicely
void KPACKAGE::arrangeWidgets()
{
  int i;

  statusbar->resize(width(),20);
  statusbar->move(0,height()-20);
  status->resize((statusbar->width() / 4) * 3, 16);
  status->move(2,2);
  processProgress->resize(statusbar->width() / 4 - 4, 16);
  processProgress->move((statusbar->width() / 4) * 3 + 3, 2);
  
  management->resize(width(),height() - 20);

  for (i = 0; i < kpinterfaceN; i++) 
    kpinterface[i]->installation->resize(width(),height() - 20);
}

// Change the mode
void KPACKAGE::setMode(int newmode, pkgInterface *type, int refresh) 
{ 
  int i;

  if(newmode == Management)	// entering management mode so...
    {
      management->show();	// show the management widget
      kapp->processEvents();
      for (i = 0; i < kpinterfaceN; i++)
	kpinterface[i]->installation->hide();
      kpkg->enableMenu();
      management->collectData(refresh); // refresh the management widget
    }
  else				// entering installation mode so...
    {
      for (i = 0; i < kpinterfaceN; i++) {// hide all except the 
	if (kpinterface[i] == type)       // correct install widget
	  kpinterface[i]->installation->show();
	else
	  kpinterface[i]->installation->hide();
      }
      kpkg->disableMenu();
      
      management->hide();	// hide the management widget
    }
}

void KPACKAGE::fileQuit()		// file->quit selected from menu
{
  kpkg->writeSettings();
  if (params->DCache >= Params::SESSION) {
    cacheObj::clearDCache(); // clear dir caches if needed
  }
  if (params->PCache >= Params::SESSION) {
    cacheObj::clearPCache(); // clear package caches if needed
  }

  KApplication::exit(0);	// exit the application
}

void KPACKAGE::reload()
{
  kpackage->management->collectData(TRUE);
}

void KPACKAGE::fileOpen()		// file->quit selected from menu
{
    QString fname;
    KFileDialog *box;
    //    pkgInterface *type;

    box = getFileDialog(i18n("Select Document to Open"));
    
    box->show();
    
    if (!box->result())   /* cancelled */
      return;
    if(box->selectedURL().isEmpty()) {  /* no selection */
      return;
    }
    

    fname =  box->selectedURL().url();
    openNetFile(fname);
}

void KPACKAGE::clearMarked()
{
  management->clearMarked(management->treeList->firstChild());
}

void KPACKAGE::expandTree()
{
  management->expandTree(management->treeList);
}

void KPACKAGE::collapseTree()
{
  management->collapseTree(management->treeList);
}

pkgInterface *KPACKAGE::pkType(const char *fname)
{
  // Get the package information for this package
  char buf[51];
  int i;

  FILE *file= fopen(fname,"r");
  if (file) {
    fgets(buf,sizeof(buf)-1,file);
    buf[50] = 0;
 
    for (i = 0; i < kpinterfaceN; i++) {
      if (kpinterface[i]->isType(buf, fname)) {
	fclose(file);
	return kpinterface[i];
      }
    }
    fclose(file);
    KpMsgE(i18n("Unknown package type: %1").arg(fname),TRUE);
  } else {
    KpMsgE(i18n("File not found: %1").arg(fname),TRUE);
  }

  return 0;
}

/////////////////////////////////////////////////////////////////////////

void KPACKAGE::openNetFile( const char *_url )
{
  QString s = fetchNetFile(_url);
  kpkg->add_recent_file(_url);
  if (!s.isEmpty()) {
    pkgInterface *type = pkType(s.data());

    //    KMimeMagic *magic = KMimeMagic::self();
    //    KMimeMagicResult *r = magic->findFileType(s);
    //    printf("r=%s\n",(r->mimeType()).data());

    if (type) {
      setMode(Installation,type,0);	// enter installation mode
      installPackage(s.data(),type);	// start installing this package
    }
  }
}

QString KPACKAGE::getFileName(QString url, QString &cacheName )
{
  QString none  = "";
  QString fname = "";

  KURL *u = new KURL( url.data() );
  if ( u->isMalformed() )  {
    delete u; 

    if (url.data()[0] == '/') {	// absolute path
      u=new KURL( QString(QString("file:")+QString(url.data())) );
    } else {
      u=new KURL( QString(QString("file:")+
			  QDir::currentDirPath()+"/"+QString(url.data())) );
    }
  }
  if (u->isMalformed()) {
    KpMsgE(i18n("Malformed URL: %1").arg(url),TRUE);
  } else {

    // Just a usual file ?
    if ( strcmp( u->protocol(), "file" ) == 0 ) {
      cacheName = u->path();
      fname = u->path();
    } else {
    
      QString tmpd = cacheObj::PDir();
      if (!tmpd.isEmpty()) {

	QString cacheFile;
	QString file = u->path();
	int pt = file.findRev('/');
	pt++;
	if (pt >= 0) {  			// file name for cache
	  cacheFile = tmpd + file.right(file.length() - pt);
	} else {
	  cacheFile = tmpd + file;
	}

	cacheName = cacheFile.data();
	QFileInfo f(cacheFile.data());
	if (f.exists() && (params->DCache != Params::NEVER)) {
	  fname =  cacheFile;
	}
      }
    }
  }
  delete u;
  return fname;
}
     
QString KPACKAGE::fetchNetFile( QString url )
{

  QString cf;

  QString f = getFileName(url, cf);

  if (cf.isEmpty()) {
    return "";
  } else {

    if (!f.isEmpty()) {
      return f;
    } else {
      save_url = url;

      setStatus(i18n("Calling KFM"));
  
      Kio kio;

      if (kio.download(url, cf)) {
	setStatus(i18n("KFM finished"));
	QFileInfo f(cf.data());
	if (!(f.exists() && f.size() > 0)) {
	  unlink(cf.data());
	  return "";
	} else {
	  return cf;
	}
      } else {
	setStatus(i18n("KFM failed"));
	return "";
      }
    }
  }
}

/////////////////////////////////////////////////////////////////////////
void KPACKAGE::fileOpenUrl(){

  KLineEditDlg geturl( i18n("Open Location:"), save_url.data(), this );

  if ( geturl.exec() )
    {
      kpkg->add_recent_file(geturl.text());
      openNetFile( geturl.text() );
    }
}

void KPACKAGE::find(){
  if (srchdialog)
    srchdialog->show();
  else
    srchdialog = new Search(0, "find package");
}

void KPACKAGE::findf(){
  if (findialog)
    findialog->show();
  else
    findialog = new FindF(0, "find ffile");
}

KFileDialog* KPACKAGE::getFileDialog(const char* captiontext){

  if(!file_dialog) {
    QString pat;
    for (int i = 0; i < kpinterfaceN; i++) {
      pat += kpinterface[i]->packagePattern;
      pat += " ";
    }
    file_dialog = new KFileDialog(QDir::currentDirPath(), pat,
				  this,"file_dialog",TRUE);
  }

  file_dialog->setCaption(captiontext);
  //  file_dialog->rereadDir();

  return file_dialog;
}

void KPACKAGE::helpAbout()	// help->about selected from menu
{
  aboutDialog *about = new aboutDialog(this); // create the about box
  about->exec();		// execute the about box
  delete about;			// delete the about box
}

void KPACKAGE::helpHelp()		// Help->Help selected from menu
{
  kapp->invokeHelp( );  
}

void KPACKAGE::dropEvent(QDropEvent *de) // something has been dropped
{
  int i = 0;

  // Call openNetFile with the first URL, save the rest to be processed
  QStrList list;
  QUriDrag::decode(de, list);
  kpkg->urlList.clear();

  for ( const char *s = list.first();
	s != 0;
	s = list.next(), i++ ) {
    if (i == 0)
      openNetFile(s);
    else
      kpkg->urlList.append(s);
  }
}

void KPACKAGE::installPackage(const char *name, pkgInterface *type)	// start installing package
{
    type->installation->installPackage(name); // so tell the installation widget about it
}

void KPACKAGE::modeFinished(int mode, pkgInterface *interface, int refresh) // a mode has finished
{				// so set the new mode appropriately
  if(mode == Installation)
    setMode(Management, interface, refresh);
  else
    setMode(Installation, interface, refresh);
}

void KPACKAGE::setStatus(const char *s)	// set the text in the status bar
{
  status->setText(s);
  kapp->processEvents();	// refresh the screen
}

QString KPACKAGE::getStatus()	// get the text in the status bar
{
  if(status)
    return status->text();
  else 
    return "";
}

void KPACKAGE::setPercent(int x)	// set the progress in the status bar
{
  processProgress->setValue(x);
  kapp->processEvents();	// refresh it
}

//////////////////////////////////////////////////////////////////////////////



