/* -*- C++ -*-

  $Id: UngroupCmd.h,v 1.5 2000/02/08 20:46:41 kulow Exp $

  This file is part of KIllustrator.
  Copyright (C) 1998 Kai-Uwe Sattler (kus@iti.cs.uni-magdeburg.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by  
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef UngroupCmd_h_
#define UngroupCmd_h_

#include <list>
#include <utility>

#include "Command.h"

class GDocument;
class GGroup;
class GObject;

class UngroupCmd : public Command {
public:
  UngroupCmd (GDocument* doc);
  ~UngroupCmd ();

  void execute ();
  void unexecute ();

private:
  GDocument* document;
  typedef std::pair<GGroup*, std::list<GObject*> > GPair;
  std::list<GPair> groups;
};

#endif
