/*********************************************************************
 *
 * This is based on code created by Peter Harvey,
 * (pharvey@codebydesign.com).
 *
 * Modified and extended by Nick Gorham
 * (nick@easysoft.com).
 *
 * Any bugs or problems should be considered the fault of Nick and not
 * Peter.
 *
 * copyright (c) 1999 Nick Gorham
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **********************************************************************
 *
 * $Id: SQLSetEnvAttr.c,v 1.2 1999/12/10 01:50:37 harvey Exp $
 *
 * $Log: SQLSetEnvAttr.c,v $
 * Revision 1.2  1999/12/10 01:50:37  harvey
 * Updated with current sources from unixODBC cvs.
 *
 * Revision 1.7  1999/11/13 23:41:01  ngorham
 *
 * Alter the way DM logging works
 * Upgrade the Postgres driver to 6.4.6
 *
 * Revision 1.6  1999/10/24 23:54:19  ngorham
 *
 * First part of the changes to the error reporting
 *
 * Revision 1.5  1999/09/21 22:34:25  ngorham
 *
 * Improve performance by removing unneeded logging calls when logging is
 * disabled
 *
 * Revision 1.4  1999/07/10 21:10:17  ngorham
 *
 * Adjust error sqlstate from driver manager, depending on requested
 * version (ODBC2/3)
 *
 * Revision 1.3  1999/07/04 21:05:08  ngorham
 *
 * Add LGPL Headers to code
 *
 * Revision 1.2  1999/06/30 23:56:55  ngorham
 *
 * Add initial thread safety code
 *
 * Revision 1.1.1.1  1999/05/29 13:41:08  sShandyb
 * first go at it
 *
 * Revision 1.1.1.1  1999/05/27 18:23:18  pharvey
 * Imported sources
 *
 * Revision 1.3  1999/05/09 23:27:11  nick
 * All the API done now
 *
 * Revision 1.2  1999/04/30 16:22:47  nick
 * Another checkpoint
 *
 * Revision 1.1  1999/04/25 23:06:11  nick
 * Initial revision
 *
 *
 **********************************************************************/

#include "drivermanager.h"

static char const rcsid[]= "$RCSfile: SQLSetEnvAttr.c,v $ $Revision: 1.2 $";

SQLRETURN SQLSetEnvAttr( SQLHENV environment_handle,
           SQLINTEGER attribute,
           SQLPOINTER value,
           SQLINTEGER string_length )
{
    DMHENV environment = (DMHENV) environment_handle;
    SQLCHAR s0[ 20 ], s1[ 100 ];

    /*
     * check environment
     */

    if ( !__validate_env( environment ))
    {
        return SQL_INVALID_HANDLE;
    }

    function_entry( environment );

    if ( environment -> log_handle )
    {
        sprintf( environment -> msg, "\n\t\tEntry:\
            \n\t\t\tEnvironment = %p\
            \n\t\t\tAttribute = %s\
            \n\t\t\tValue = %p\
            \n\t\t\tStrLen = %p",
                environment,
                __env_attr_as_string( s1, attribute ),
                value, 
                (void*)string_length );

        dm_log_write( environment -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                environment -> msg );
    }

    thread_protect( SQL_HANDLE_ENV, environment );

    switch ( attribute )
    {
      case SQL_ATTR_CONNECTION_POOLING:
        {
            int ptr = (int) value;

            if ( ptr != SQL_CP_OFF &&
                ptr != SQL_CP_ONE_PER_DRIVER &&
                ptr != SQL_CP_ONE_PER_HENV )
            {
                dm_log_write( environment -> log_handle, 
                        __get_pid( s0 ), 
                        __FILE__, 
                        __LINE__, 
                        LOG_INFO, 
                        LOG_INFO, 
                        "Error: HY024" );

                __post_internal_error( &environment -> error,
                        ERROR_HY024, NULL,
                        environment -> requested_version );

                thread_release( SQL_HANDLE_ENV, environment );

                return function_return( environment, SQL_ERROR );
            }

            environment -> connection_pooling = ptr;
        }
        break;

      case SQL_ATTR_CP_MATCH:
        {
            int ptr = (int) value;

            if ( ptr != SQL_CP_STRICT_MATCH &&
                ptr != SQL_CP_RELAXED_MATCH )
            {
                dm_log_write( environment -> log_handle, 
                        __get_pid( s0 ), 
                        __FILE__, 
                        __LINE__, 
                        LOG_INFO, 
                        LOG_INFO, 
                        "Error: HY024" );

                __post_internal_error( &environment -> error,
                        ERROR_HY024, NULL,
                        environment -> requested_version );

                thread_release( SQL_HANDLE_ENV, environment );

                return function_return( environment, SQL_ERROR );
            }

            environment -> cp_match = ptr;
        }
        break;

      case SQL_ATTR_ODBC_VERSION:
        {
            int ptr = (int) value;

            if ( ptr != SQL_OV_ODBC2 &&
                    ptr != SQL_OV_ODBC3 )
            {
                dm_log_write( environment -> log_handle, 
                        __get_pid( s0 ), 
                        __FILE__, 
                        __LINE__, 
                        LOG_INFO, 
                        LOG_INFO, 
                        "Error: HY024" );

                __post_internal_error( &environment -> error,
                        ERROR_HY024, NULL,
                        environment -> requested_version );

                thread_release( SQL_HANDLE_ENV, environment );

                return function_return( environment, SQL_ERROR );
            }
            else
            {
                environment -> requested_version = ptr;
            }
        }
        break;

      case SQL_ATTR_OUTPUT_NTS:
        {
            int ptr = (int) value;

            /*
             * this must be one of the most brain dead atribute,
             * it can be set, but only to TRUE, any other value
             * (ie FALSE) returns a error. Its almost as if its not
             * settable :-)
             */

            if ( ptr == SQL_FALSE )
            {
                dm_log_write( environment -> log_handle, 
                        __get_pid( s0 ), 
                        __FILE__, 
                        __LINE__, 
                        LOG_INFO, 
                        LOG_INFO, 
                        "Error: HYC00" );

                __post_internal_error( &environment -> error,
                        ERROR_HYC00, NULL,
                        environment -> requested_version );

                thread_release( SQL_HANDLE_ENV, environment );

                return function_return( environment, SQL_ERROR );
            }
        }
        break;

      default:
        dm_log_write( environment -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                "Error: HY092" );

        __post_internal_error( &environment -> error,
                ERROR_HY092, NULL,
                environment -> requested_version );

        thread_release( SQL_HANDLE_ENV, environment );

        return function_return( environment, SQL_ERROR );
    }

    if ( environment -> log_handle )
    {
        sprintf( environment -> msg, 
                "\n\t\tExit:[%s]",
                    __get_return_status( SQL_SUCCESS ));

        dm_log_write( environment -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                environment -> msg );
    }

    thread_release( SQL_HANDLE_ENV, environment );

    return SQL_SUCCESS;
}
