/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#include <stdlib.h>

#include <qregexp.h>

#include <kstddirs.h>

#include "misc.h"
#include "newssearch.h"


NewsSiteManager::NewsSiteManager() {
  KGlobal::dirs()->addResourceType("news-sites", KStandardDirs::kde_default("data") + "libsearch/news-sites/");
  QStringList list = KGlobal::dirs()->findDirs("news-sites", "");
  
  for (QStringList::ConstIterator it = list.begin(); it != list.end(); it++) {
    readSites( *it );
  }
}


void NewsSiteManager::readInterpret(Site *site, SiteConfig *config) {
  NewsSite *cnsite = static_cast<NewsSite*>(site);
  cnsite->dateStart = config->readEntry("dateStart");
  cnsite->dateEnd = config->readEntry("dateEnd");
  cnsite->subjectStart = config->readEntry("subjectStart");
  cnsite->subjectEnd = config->readEntry("subjectEnd");
  cnsite->forumStart = config->readEntry("forumStart");
  cnsite->forumEnd = config->readEntry("forumEnd");
  cnsite->authorStart = config->readEntry("authorStart");
  cnsite->authorEnd = config->readEntry("authorEnd");
}


void NewsSearch::parseItem(QString item) {
  int pos1, pos2, pos3;
  QString url, date, subject, forum, author;

#if 0
  qDebug( "-----------------------------------------------------------" );
  qDebug( "Parsing Item: " + item + " |" );
  qDebug( "-----------------------------------------------------------" );
#endif
    
  // This parser sucks.
  pos1 = item.find(site()->dateStart);
  if (pos1 == -1)
    return;
    
  pos2 = item.find(site()->dateEnd);
  if (pos2 == -1)
    return;

  pos1 += site()->dateStart.length();
  date = item.mid(pos1, pos2-pos1);
  item.remove(0, pos2+site()->dateEnd.length());
  qDebug( "Datestring: " + date );
    
  pos1 = item.find(site()->subjectStart);
  if (pos1 == -1)
    return;
    
  pos2 = item.find(site()->subjectEnd);
  if (pos2 == -1)
    return;

  pos1 += site()->subjectStart.length();
  subject = item.mid(pos1, pos2-pos1);
  item.remove(0, pos2+site()->subjectEnd.length());
  qDebug( "Subjectstring: " + subject );

  pos1 = item.find(site()->forumStart);
  if (pos1 == -1)
    return;
    
  pos2 = item.find(site()->forumEnd);
  if (pos2 == -1)
    return;

  pos1 += site()->forumStart.length();
  forum = item.mid(pos1, pos2-pos1);
  item.remove(0, pos2+site()->forumEnd.length());
  qDebug( "Forumstring: " + forum );
    
  pos1 = item.find(site()->authorStart);
  if (pos1 == -1)
    return;
    
  pos2 = item.find(site()->authorEnd);
  if (pos2 == -1)
    return;

  pos1 += site()->authorStart.length();
  author = item.mid(pos1, pos2-pos1);
  item.remove(0, pos2+site()->authorEnd.length());
  qDebug( "Authorstring: " + author );

  // Find url inside subject
  qDebug( "Subjectstring: " + subject );
  pos1 = subject.find(QRegExp("<a href=", false));
  if (pos1 != -1) {
    qDebug( "Pos1: %d", pos1 );
    pos2 = subject.find(">", pos1+8);
    qDebug( "Pos2: %d", pos2 );
    if (pos2 != -1) {
      pos3 = subject.find(QRegExp("</a>", false), pos2+1);
      qDebug( "Pos3: %d", pos3 );

      if (pos3 != -1) {
	url = subject.mid(pos1+8, pos2-(pos1+8)).stripWhiteSpace();
      }
      if (url.left(1) == "\"") {
	url.remove(0, 1);
      }
      if (url.right(1) == "\"") {
	url.remove(url.length()-1, 1);
      }

      qDebug( "Url: " + url );
    }
  }
  
  date = removeHTML(date).stripWhiteSpace();
  subject = removeHTML(subject).stripWhiteSpace();
  forum = removeHTML(forum).stripWhiteSpace();
  author = removeHTML(author).stripWhiteSpace();
  emit foundItem(date, subject, url, forum, author);
}
