/*
* popcfg.cpp -- Implementation of class KPopCfg.
* Author:	Sirtaj Singh Kang
* Version:	$Id: popcfg.cpp,v 1.1 1999/07/22 18:17:07 tibirna Exp $
* Generated:	Mon Aug  3 14:58:11 EST 1998
*/

#include <assert.h>
#include <stdlib.h>

#include <qlined.h>
#include <qchkbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>

#include <kglobal.h>
#include <klocale.h>

//#include"typolayout.h"

#include "pop.h"
#include "popcfg.h"

KPopCfg::KPopCfg( KPop3Drop *drop )
	: KMonitorCfg( drop ),
	_serverEdit( 0 ),
	_portEdit( 0 ),
	_userEdit( 0 ),
	_pwdEdit( 0 )
{
}

const QString KPopCfg::name() const
{
	return i18n("POP 3");
}

QWidget *KPopCfg::makeWidget( QWidget *parent )
{
	KPop3Drop *d = (KPop3Drop *) drop();
	assert( d != 0 );

	QWidget *dlg = new QWidget( parent );
	QBoxLayout *layout = new QVBoxLayout( dlg, 10 );
	layout->addSpacing(10);

	QGroupBox *aGroup = new QGroupBox( i18n("Server"), dlg );
	layout->addWidget( aGroup );
	
	QGridLayout *slay = new QGridLayout( aGroup, 3, 2, 10 );
	slay->addRowSpacing(0, 10);

	slay->addWidget( new QLabel( i18n("Server"), aGroup ), 1, 0 );

	_serverEdit = new QLineEdit( d->server(), aGroup );
	slay->addWidget( _serverEdit, 1, 1 );
	
	QString sport;
	sport.setNum( d->port() );
	slay->addWidget(new QLabel( i18n("Port"), aGroup ), 2, 0);

	_portEdit = new QLineEdit( sport, aGroup );
	slay->addWidget( _portEdit, 2, 1);

	aGroup = new QGroupBox( i18n( "Identity" ), dlg );
	layout->addWidget( aGroup );

	slay = new QGridLayout ( aGroup, 4, 2, 10);
	slay->addRowSpacing (0, 10);

	slay->addWidget( new QLabel( i18n("Username"), aGroup ), 1, 0);

	_userEdit = new QLineEdit( d->user(), aGroup );
	slay->addWidget( _userEdit, 1, 1);
	
	slay->addWidget( new QLabel( i18n("Password"), aGroup ), 2, 0);

	_pwdEdit = new QLineEdit( d->password(), aGroup );
	slay->addWidget( _pwdEdit, 2, 1);
	_pwdEdit->setEchoMode( QLineEdit::Password );

	_savePass = new QCheckBox( i18n( "Save Password"), aGroup );
	slay->addWidget( _savePass, 3, 1);

	connect( _savePass, SIGNAL(toggled(bool)), _pwdEdit,
		SLOT(setEnabled(bool)) );

	return dlg;
}

void KPopCfg::updateConfig()
{
	assert( _serverEdit != 0 );
	assert( _portEdit != 0 );
	assert( _userEdit != 0 );
	assert( _pwdEdit != 0 );
	assert( _savePass != 0 );

	KPop3Drop *d = (KPop3Drop *) drop();
	assert( d != 0 );

	d->setPopServer( _serverEdit->text(), atoi( _portEdit->text() ) );
	d->setUser( _userEdit->text(), _pwdEdit->text(), 
		_savePass->isChecked() );
}
