/*
* pop.cpp -- Implementation of class KPop3Drop.
* Author:	Sirtaj Singh Kang
* Version:	$Id: pop.cpp,v 1.2 1999/07/25 17:32:46 kulow Exp $
* Generated:	Tue Apr 21 18:12:41 EST 1998
*/

#include<stdio.h>

#include<kconfigbase.h>

#include<mimelib/pop.h>


#include"pop.h"
#include"popcfg.h"
#include"dropdlg.h"

KPop3Drop::KPop3Drop()
	: KPollableDrop(),
	_server( "" ),
	_port( 0 ),
	
	_user( "" ),
	_password( "" ),
	_savePassword( false ),

	_valid (false ),
	_pop( 0 )
{
}

void KPop3Drop::setPopServer( const char *server, int port )
{
	_server = server ? server : "";
	_port	= port;
}

void KPop3Drop::setUser( const char *user, const char *password, 
	bool savepass )
{
	_user = user ? user : "";
	_password = password ? password : "";
	_savePassword = savepass;

	_valid = true;
}

void KPop3Drop::recheck()
{
	if( _pop == 0 ) {
		_pop = new DwPopClient;
	}

	int ret = _pop->Open( _server, _port );

	if( !ret ) {
		_valid = false;
		return;
	}

	ret = _pop->User( _user );

	if( ret == '-' ) {
		_valid = false;
		_pop->Quit();
		_pop->Close();

		return;
	}

	ret = _pop->Pass( _password );

	if( ret == '-' ) {
		_valid = false;
		_pop->Quit();
		_pop->Close();

		return;
	}

	ret = _pop->Stat();

	if( ret == '-' ) {
		_valid = false;
		_pop->Quit();
		_pop->Close();

		return;
	}

	DwString response = _pop->SingleLineResponse();

	int newcount=0, octets=0;

	sscanf( response.c_str(), "+OK %d %d", &newcount, &octets );

	_pop->Quit();
	_pop->Close();

	if( newcount != count() ) {
		emit changed( newcount );
	}

	_valid = true;
	return;
}

bool KPop3Drop::valid()
{
	return _valid;
}

KPop3Drop::~KPop3Drop()
{
	delete _pop;
}

KMailDrop* KPop3Drop::clone() const 
{
	KPop3Drop *clone = new KPop3Drop;

	*clone = *this;

	return clone;
}

bool KPop3Drop::readConfigGroup( const KConfigBase& cfg )
{
	QString val;
	KPollableDrop::readConfigGroup( cfg );

	val = cfg.readEntry( HostConfigKey );
	if( val.isEmpty() ) { _valid = false; return false; }
	setPopServer( val, cfg.readNumEntry( PortConfigKey, DefaultPort ) );

	_user = cfg.readEntry( UserConfigKey );
	if( _user.isEmpty() ) { _valid = false; return false; }

	_password = cfg.readEntry( PassConfigKey, "" );

	if( _password.isEmpty() ) {
		_savePassword = false;
	}
	else {
		_savePassword = true;
		decrypt( _password );
	}

	return true;
}

bool KPop3Drop::writeConfigGroup( KConfigBase& cfg ) const
{
	KPollableDrop::writeConfigGroup( cfg );
	QString p = "";

	if( _savePassword == true ) {
		p = _password.data();
		encrypt( p );
	}

	cfg.writeEntry( HostConfigKey, _server );
	cfg.writeEntry( PortConfigKey, _port );
	cfg.writeEntry( UserConfigKey, _user );
	cfg.writeEntry( PassConfigKey, p );

	return true;
}

KPop3Drop& KPop3Drop::operator = ( const KPop3Drop& other )
{
	setPopServer( other._server, other._port );
	setUser( other._user,other._password );
	setFreq( other.freq() );

	return *this;
}

void KPop3Drop::addConfigPage( KDropCfgDialog *dlg )
{
	dlg->addConfigPage( new KPopCfg( this ) );

	KPollableDrop::addConfigPage( dlg );
}

void KPop3Drop::encrypt( QString& str )
{
	unsigned int i, val;
	unsigned int len = str.length();
	QString result;

	for ( i=0; i < len; i++ )
	{
		char c = str[ i ].latin1();

		val = c - ' ';
		val = (255-' ') - val;
		result[i] = (char)(val + ' ');
	}
	result[i] = '\0';
}

void KPop3Drop::decrypt( QString& str )
{
	encrypt( str );
}

const char *KPop3Drop::HostConfigKey = "host";
const char *KPop3Drop::PortConfigKey = "port";
const char *KPop3Drop::UserConfigKey = "user";
const char *KPop3Drop::PassConfigKey = "pass";
const char *KPop3Drop::SavePassConfigKey = "savepass";
const int  KPop3Drop::DefaultPort	= 110;
