
#ifndef SSK_KORNBUTT_H
#define SSK_KORNBUTT_H

#include <qcolor.h>

#include <qtoolbutton.h>

class KMailDrop;
class KornSettings;

class KornButton: public QToolButton
{
	Q_OBJECT;

private:
	KMailDrop *_box;
	int _lastNum;
	bool _reversed;

	QColor _drawColour;
	QPixmap _bg;

public:
	
	KornButton( QWidget *parent, KMailDrop *box );

public slots:

	/// draws button with the number.
	void setNumber( int );
	/// runs the click command associated with this mailbox.
	void runCommand();
	/// runs the click command if there is unread mail
	void runIfUnread();

private slots:
	void disconnectMonitor();
	void monitorUpdated();

protected:
	virtual void drawButton( QPainter * );
	virtual void mouseDoubleClickEvent( QMouseEvent * );
	virtual void mouseReleaseEvent( QMouseEvent * );
	virtual void mousePressEvent( QMouseEvent * );
	virtual void resizeEvent( QResizeEvent * );

signals:
	void doubleClick();
	void rightClick();
	void middleClick();
	void leftClick();

	void dying(KornButton *);
};

#endif
