/*
* ecfg.cpp -- Implementation of class KExternCfg.
* Author:	Sirtaj Singh Kang
* Version:	$Id: ecfg.cpp,v 1.1 1999/07/22 18:16:51 tibirna Exp $
* Generated:	Sat Nov 21 18:50:13 EST 1998
*/

#include <assert.h>
#include <qlined.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>

#include <kglobal.h>
#include <klocale.h>

//#include"typolayout.h"

#include"ecfg.h"
#include"edrop.h"

KExternCfg::KExternCfg( KExternDrop *drop )
	: KMonitorCfg( drop ),
	_cmdEdit( 0 )
{
}

const QString KExternCfg::name() const
{
	return i18n( "Process" );
}

QWidget *KExternCfg::makeWidget( QWidget *parent )
{

	KExternDrop *d = (KExternDrop *) drop();

	QWidget *dlg = new QWidget( parent );
	QBoxLayout *l = new QVBoxLayout ( dlg, 10 );
	l->addSpacing(10);

	QGroupBox *aGroup = new QGroupBox( i18n( "Process" ), dlg );
	l->addWidget(aGroup);

	l = new QHBoxLayout( aGroup, 10);
	l->addSpacing(10);

	l->addWidget( new QLabel( i18n( "Shell Command" ), aGroup ) );
	_cmdEdit = new QLineEdit( "", aGroup );

	l->addWidget( _cmdEdit );

	if( d->valid() ) {
		_cmdEdit->setText( d->command() );
	}

	return dlg;
}

void KExternCfg::updateConfig()
{
	assert( _cmdEdit != 0 );

	KExternDrop *d = (KExternDrop *) drop();
	d->setCommand( _cmdEdit->text() );
}
