/* -*- C++ -*-
 *
 *   KDE network utilities (knu.h)
 *
 *   Copyright (C) 1997-1999  Bertrand Leconte
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * $Id: knu.h,v 1.12 1999/10/08 22:52:28 bero Exp $
 *
 * $Log: knu.h,v $
 * Revision 1.12  1999/10/08 22:52:28  bero
 * KTMainWindow
 *
 * Revision 1.11  1999/10/08 04:24:55  corey
 * Added a netstat tab.
 *
 * Revision 1.10  1999/06/18 21:22:11  leconte
 * . use KTMainWindow insteed of KTMainWindow
 * . myListManager added here (it will perhaps goes to kdelibs)
 * . klistmanagertest added
 * . some cleanup
 *
 * Revision 1.9  1999/03/24 21:02:54  leconte
 * . whois command added
 * . finger can now be called with an empty user (asked by
 *         "Raul Dias" <raul@dias.com.br>)
 * . small QStrings mods
 *
 * Revision 1.8  1999/03/13 16:19:44  mario
 * Mario: made it work for Qt 2.0
 *
 * Revision 1.7  1999/03/01 23:39:39  kulow
 * CVS_SILENT ported to Qt 2.0
 *
 * Revision 1.6.4.1  1999/02/22 22:30:06  kulow
 * CVS_SILENT replaced old qt header names with new ones
 *
 * Revision 1.6  1998/10/14 19:33:04  leconte
 * Bertrand: Added mtr support (with a patch to mtr-0.21)
 *
 * Revision 1.5  1998/06/09 21:18:06  leconte
 * Bertrand: correction of bug #745 (reported by Duncan Haldane):
 * 	arguments are now added to the command line
 *
 * Revision 1.4  1998/03/01 19:30:24  leconte
 * - added a finger tab
 * - internal mods
 *
 * Revision 1.3  1997/12/07 23:44:15  leconte
 * - handle the binary's name modification dynamicaly (problem reported
 *   by Conrad Sanderson)
 * - added browse button to the option dialog (for binary selection)
 * - code clean-up
 * - better fallback to"nslookup" if "host" is not found
 *
 * Revision 1.2  1997/11/23 22:28:19  leconte
 * - Id and Log added in the headers
 * - Patch from C.Czezatke applied (preparation of KProcess new version)
 *
 */

#ifndef _KNU_H
#define _KNU_H

#include <kapp.h>
#include <ktabctl.h>

#include <qpushbutton.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qaccel.h>
#include <qframe.h>

#include <ktmainwindow.h>

#include "PingDlg.h"
#include "TracerouteDlg.h"
#include "HostDlg.h"
#include "FingerDlg.h"
#include "MtrDlg.h"
#include "WhoisDlg.h"
#include "NetstatDlg.h"
#include "OptionsDlg.h"

/**
 * Main widget
 */
class TopLevel: public KTMainWindow
{
  Q_OBJECT

public:
  TopLevel(QWidget *parent=0, const char *name=0);
  ~TopLevel();
  //CommandDlg **getPages(int *pn) { *pn=pagesNumber; return pages; };
    
protected:
  virtual void saveProperties(KConfig*);
  virtual void readProperties(KConfig*);
  
  QPopupMenu    *fileMenu, *editMenu, *helpMenu;
  KMenuBar      *menuBar;
  KTabCtl       *tabCtrl;
  int            configIndex;
  int            closeIndex;
  CommandDlg    *pages[10];
  static CommandCfgDlg *cfgPages[10];
  int            pagesNumber;

public slots:
  void slotTabChanged(int);
  void slotQuit();  
  void slotClose();  
  void slotCopy();  
  void slotSelectAll();  
  void slotHelp();  
  void slotConfig();  
  void slotClear();  
  void slotNew();
  void checkBinaryAndDisplayWidget();
  void enableFileClose(bool);

private:
  KConfig    *kconfig;
  int         currentTab;

  //public:
  //  static QList<TopLevel>  windowList;

protected:
  void createMenu();

};

#endif

