/*
 * status.cpp
 * Copyright (C) 1999 Kurt Granroth <granroth@kde.org>
 *
 * This file contains the implementation of the KBiffStatus
 * widget
 *
 * $Id: status.cpp,v 1.8 1999/12/25 02:12:06 granroth Exp $
 */
#include "status.h"

#include "Trace.h"
#include <kapp.h>

#include <qlistview.h>
#include <qheader.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpoint.h>
#include <klocale.h>

KBiffStatus::KBiffStatus(const QString& profile, const KBiffStatusList& list)
	: QFrame(0, 0, WStyle_Customize | WStyle_NoBorder),
	  _listView(new QListView(this))
{
TRACEINIT("KBiffStatus::KBiffStatus()");
	setFrameStyle(WinPanel|Raised);
	QLabel *profile_label = new QLabel(profile, this);
	profile_label->setFrameStyle(QFrame::Box | QFrame::Raised);
	profile_label->setAlignment(AlignCenter);

	_listView->addColumn(i18n("Mailbox"));
	_listView->addColumn(i18n("New"));
	_listView->setColumnAlignment(1, AlignRight);
	_listView->setSorting(1, FALSE);
	_listView->setFrameStyle(QFrame::WinPanel | QFrame::Raised);
	_listView->setVScrollBarMode(QScrollView::AlwaysOff);
	_listView->setHScrollBarMode(QScrollView::AlwaysOff);
	_listView->header()->hide();

    KBiffStatusListIterator it(list);
	for(it.toFirst(); it.current(); ++it)
	{
		new QListViewItem(_listView, it.current()->mailbox(),
						  it.current()->newMessages());
	}

	_listView->setMinimumSize(_listView->sizeHint());
	int list_height = (_listView->firstChild()->height() * list.count()) + 10;
	_listView->setMinimumSize(_listView->sizeHint().width() + 5, list_height);

	QVBoxLayout *layout = new QVBoxLayout(this, 0, 0);
	layout->addWidget(profile_label);
	layout->addWidget(_listView);
}

KBiffStatus::~KBiffStatus()
{
}

void KBiffStatus::popup(const QPoint& pos)
{
	QWidget *desktop = KApplication::desktop();
	int x = pos.x(), y = pos.y();

    // for some reason, the width and height are incorrect until
    // we do the show.  so we show first and move later
	show();

	// verify that the width is within the desktop
	if ((pos.x() + width()) > desktop->width())
	{
		x = pos.x() - width();
		x = (x < 0) ? 0 : x;
	}

	// verify that that height is within tolerances
	if ((pos.y() + height()) > desktop->height())
	{
		y = pos.y() - height();
		y = (y < 0) ? 0 : y;
	}

	// now that we have *real* co-ordinates, we move to them
	move(x, y);
}

KBiffStatusItem::KBiffStatusItem(const QString& mailbox, const int num_new)
	: QObject(),
      _mailbox(mailbox),
	  _newMessages(QString().setNum(num_new))
{
}

KBiffStatusItem::~KBiffStatusItem()
{
}
