/*
 * kbiffurl.h
 * Copyright (C) 1999 Kurt Granroth <granroth@kde.org>
 * Copyright (C) 1999 Bjorn Hansson <Bjorn.Hansson@signal.uu.se>
 *
 * $Id: kbiffurl.h,v 1.2 1999/12/25 02:12:05 granroth Exp $
 *
 */
#ifndef KBIFFURL_H
#define KBIFFURL_H

#include <kurl.h>

/**
 * This is a simple extension to the KURL class.  It adds the method
 * 'encodeURLStrict' which will also encode the '/' character.
 */
class KBiffURL : public KURL
{
public:
	/**
	 * Default constructor
	 */
	KBiffURL();

	/**
	 * Construct a KBiffURL object from _url
	 */
	KBiffURL(const QString& _url);

	/**
	 * Construct a KBiffURL object from _url
	 */
	KBiffURL(const char* _url);

	/**
	 * Escapes some reserved characters within URLs (e.g. '#', '%').
	 *
	 * This is the same as the @ref encodeURL function with the addition
	 * that it encodes the '/' character.
	 */
	static void encodeURLStrict(QString& url);

	/**
	 * Returns the parameter value found in the search part of the URL
	 */
	QString searchPar( const char *_parName ) const;

	/**
	 * Sets a parameter value in the search part of the URL
	 */
	void setSearchPar( const char *_parName, const char *_newParVal );

private:
	/**
	 * Returns the position of a parameter within the search part
	 */
	int findPos( const char *_searchPart, const char *_parName ) const;
};
#endif // KBIFFURL_H
