
#ifndef _Transfer_h
#define _Transfer_h

#include <qlistview.h>
#include <qdatetime.h>
#include <qguardedptr.h>
#include <qmap.h>

#include <kurl.h>

#include <kio/jobclasses.h>

class QTimer;

class KSimpleConfig;
class KAction;
class KRadioAction;

class FtpSearch;
class FtpSiteManager;
class KPingPool;

class DlgIndividual;
class TransferList;


class Transfer : public QObject, public QListViewItem {

  Q_OBJECT

public:
  enum TransferMode { MD_QUEUED, MD_DELAYED, MD_SCHEDULED  };

  enum TransferStatus { ST_STOPPED, ST_RUNNING, ST_TRYING,
			ST_FINISHED, ST_RETRYING,
			ST_SIZE_CHECK, ST_SEARCH };

  enum TransferOperation { OP_FINISHED, OP_FINISHED_KEEP, OP_CANCELED,
			   OP_SIZE_CHECKED, OP_ERROR,
			   OP_RESUMED, OP_PAUSED, OP_RESTARTED,
			   OP_REMOVED,
			   OP_QUEUED, OP_SCHEDULED, OP_DELAYED };

  Transfer( TransferList *view );
  Transfer( TransferList *view, Transfer *after );
  ~Transfer();

  void copy( Transfer* );

  bool read( KSimpleConfig *config, int id );
  void write( KSimpleConfig *config, int id );

  // getter methods
  KURL getSrc() { return src; }
  KURL getDest() { return dest; }
  QDateTime getStartTime() { return startTime; }
  unsigned long getTotalSize() { return totalSize; }
  unsigned long getProcessedSize() { return processedSize; }
  int getPercent() { return percent; }
  int getTotalFiles() { return totalFiles; }
  int getProcessedFiles() { return processedFiles; }
  int getSpeed() { return speed; }
  QTime getRemainingTime() { return remainingTime; }
  int getStatus() { return status; }
  int getMode() { return mode; }

  // setter methods
  void setSrc( const KURL& _src );
  void setDest( const KURL& _dest ) { dest = _dest; }
  void setStartTime( QDateTime _startTime ) { startTime = _startTime; }
  void setSpeed( unsigned long _speed );
  void setMode( int _mode ) { mode = _mode; }

  // update methods
  void updateAll();
  bool updateStatus( int counter );

  void showIndividual();

  void getSize();

  // actions
  KAction *m_paResume, *m_paPause, *m_paDelete, *m_paRestart;
  KRadioAction *m_paQueue, *m_paTimer, *m_paDelay;

public slots:
  // operation methods
  void slotSearch();
  void slotResume();
  void slotPause();
  void slotPauseOffline();
  void slotRestart();
  void slotRemove();

  void slotQueue();
  void slotSchedule();
  void slotDelay();

signals:
  void statusChanged( Transfer*, int _operation );
  void log( uint, const QString&, const QString& );
  void searchStarted();
  void found( QString url ); 
  void pingSpeed( QString host, float speed );

protected slots:

  // job signals
  void slotResult( KIO::Job* );
  void slotCanceled( KIO::Job* );

  void slotTotalSize( KIO::Job*, unsigned long );
  void slotTotalFiles( KIO::Job*, unsigned long );

  void slotProcessedSize( KIO::Job*, unsigned long );
  void slotProcessedFiles( KIO::Job*, unsigned long );

  void slotSpeed( KIO::Job*, unsigned long );

  void slotCopying( KIO::Job*, const KURL&, const KURL& );
  void slotRenaming( KIO::Job*, const KURL&, const KURL& );

  void slotCanResume( KIO::Job*, bool );

  void slotSearchResult( KIO::Job* );

  void slotFoundItem( QString, QString );
  void slotPingSpeed( QString, float );

  void slotSearchTimeout();
  void slotUpdateActions( Transfer*, int );

protected:

  void Connect();
  void logMessage( const QString &message );

private:
  void setupFields();

  KURL src;
  KURL dest;
  
  uint id;

  KIO::CopyJob *copyjob;
  KIO::StatJob *statjob;

  // search stuff
  FtpSearch* searchJob;
  float highestSpeed;
  QString fastestHost;
  bool b_saturated;

  typedef QMap<QString,float> HostMap;
  HostMap hosts;
  QStringList sources;

  // schedule time
  QDateTime startTime;

  unsigned long totalSize;
  unsigned long processedSize;
  int percent;
  int totalFiles;
  int processedFiles;

  int speed;
  QTime remainingTime;

  int status;
  int mode;

  // how many times have we retried already
  int retryCount;

  bool canResume;

  TransferList *view;

  QTimer* searchTimer;

  // individual download window
  DlgIndividual* dlgIndividual;

  static uint idcount;
  static FtpSiteManager* searchManager;
  static KPingPool* pinger;
};


#endif // _Transfer_h
