/* $Id: logwindow.h,v 1.9 1999/11/22 18:53:36 koss Exp $
   $Log: logwindow.h,v $
   Revision 1.9  1999/11/22 18:53:36  koss
   Added typedef for TransferMap.

   Revision 1.8  1999/11/19 18:56:09  koss
   Remove marginHint().
   Fixed caption.

   Revision 1.7  1999/11/16 18:19:15  koss
   Fixed slot names in KMainWidget

   Revision 1.6  1999/11/14 09:12:38  koss
   Ported to KDialogBase.

   Revision 1.5  1999/10/31 10:24:42  koss
   Added timestamp.
   Switched from QMultiLineEdit to QTextView.
   Now we display richtext logs with different colors for general
   messages, transfer messages & timestamp.

   Revision 1.4  1999/10/19 17:43:23  koss
   New separated log dialog.
   Philosophy : page one = all output mixed
   	     page two = separated output with QListView
   Added simplifyWhiteSpace() to create a better logs.

   Revision 1.3  1999/10/18 22:08:48  koss
   New logging - discerning general and per-transfer messages.
   Pending - finish second tab = per transfer logs
           - port to QTextView and assign colors to items


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _LOGWINDOW_H
#define _LOGWINDOW_H

#include <qlistview.h>
#include <qtextview.h>
#include <qmap.h>

#include <kdialogbase.h>

class SeparatedLog : public QWidget {

  Q_OBJECT

public:
  SeparatedLog( QWidget *parent );
  ~SeparatedLog() {}

  void addLog( uint id, const QString &filename, const QString &message );
  void refresh();

protected slots:
  void transferSelected( QListViewItem *item );

private:
  QListView *lv_log;
  QTextView *ml_log;

  typedef QMap<uint, QString> TransferMap;
  TransferMap trMap;

  uint idSelected;
};


class LogWindow : public KDialogBase {
  
  Q_OBJECT
  
public:
  LogWindow();
  ~LogWindow() {}

  void logGeneral( const QString &message );
  QString getText() const;

public slots:
  void logTransfer( uint id, const QString &filename, const QString &message );

protected:
  void closeEvent( QCloseEvent * );

private:
  QTextView *mixed_log;
  SeparatedLog *sep_log;
};


#endif // _LOGWINDOW_H
