/* $Id: dlgDirectories.h,v 1.6 1999/11/18 21:28:04 koss Exp $
   $Log: dlgDirectories.h,v $
   Revision 1.6  1999/11/18 21:28:04  koss
   Adapted to a new settings policy.
   All settings are kept in class Settings.
   No more passing over / creating QStringLists etc.

   Revision 1.5  1999/11/09 18:24:37  koss
   Ported to KDialogBase.
   Fixed layout stuff ( only QListView in dlgDirectories remains ).

   Revision 1.1  1999/04/08 17:12:20  koss
   new dialog for default directories


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _DLGDIRECTORIES_H
#define _DLGDIRECTORIES_H

#include <qgroupbox.h> 
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qstringlist.h>

#include <qlistview.h>

class DlgDirectories : public QGroupBox {

  Q_OBJECT

public:

  DlgDirectories(QWidget *parent);
  ~DlgDirectories() {}

  void applyData();
  void setData();

private:

  // table of entries
  QListView *lv_entries;

  // edit entries
  QLineEdit *le_ext;
  QLineEdit *le_dir;

  // maximum bandwidth
  QPushButton *pb_add;
  QPushButton *pb_delete;
  QPushButton *pb_change;
  QPushButton *pb_browse;

  QPushButton *pb_up;
  QPushButton *pb_down;

protected slots:

  void selectEntry( QListViewItem *item  );
  void addEntry();
  void deleteEntry();
  void changeEntry();
  void browse();

  void upEntry();
  void downEntry();

};

#endif // _DLGDIRECTORIES_H
