#ifndef _BOARDWIDGET_H_
#define _BOARDWIDGET_H_

#include <qwidget.h>
#include <qpixmap.h>

#include "Ball.h"
#include "Move.h"
#include "Board.h"


class BoardWidget : public BallWidget
{
	Q_OBJECT
	
 public:
	BoardWidget(Board&, QWidget *parent = 0, const char *name = 0);
	~BoardWidget();

	void createPos(int , int , int , Ball*);
        void initBalls();
        void updateBalls();     

	virtual void resizeEvent(QResizeEvent *);
	virtual void paintEvent(QPaintEvent *);
	virtual void mousePressEvent( QMouseEvent* pEvent );
	virtual void mouseReleaseEvent( QMouseEvent* pEvent );
	virtual void mouseMoveEvent( QMouseEvent* pEvent );

	void renderBalls(bool r);

	void draw();
	void drawBoard();
	
	void choseMove(MoveList*);

	/* enable/disable Edit Mode: 
	 * On disabling & valid position it's actually copied to Board
	 */
	bool setEditMode(bool);
	int validState();
	bool isValid() { return validState()==Board::valid; }
	
	/* copy actual board position */
	void copyPosition();
	void clearPosition();

	int getColor1Count()      { return color1Count; }
	int getColor2Count()      { return color2Count; }


 signals:
	void moveChoosen(Move&);
	void mousePressed(int);
	void updateSpy(QString);
	void edited(int);

 private:
	int positionOf(int x, int y);
	bool isValidStart(int pos, bool);
	bool isValidEnd(int pos);

	QPixmap pm, boardPM;
	Board& board;
	int actValue;

	bool editMode, renderMode;
	int editColor;

	/* copied position */
	int field[Board::AllFields];
	int color1Count, color2Count;	
	
	/* for getting user Move */
	MoveList *pList;
	Move actMove;
	bool gettingMove, mbDown, startValid, startShown;
	int startPos, actPos, oldPos, shownDirection;
	int startField, startField2, actField, oldField, startType;
	QColor *boardColor, *redColor, *yellowColor, *redHColor, *yellowHColor;
	QCursor *arrowAll, *arrow[7];

	Ball *n1, *n2, *h1, *h2, *d1, *d2; //, *e;
};

#endif /* _BOARDWIDGET_H_ */

