/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include <kdebug.h>

#include "konq_run.h"
#include "konq_mainview.h"

#include <assert.h>
#include <iostream.h>

KonqRun::KonqRun( KonqMainView* mainView, KonqChildView *_childView, const KURL & _url, mode_t _mode, bool _is_local_file, bool _auto_delete )
  : KRun( _url, _mode, _is_local_file, _auto_delete )
{
  m_pMainView = mainView;
  assert( m_pMainView );
  m_pChildView = _childView;
  m_bFoundMimeType = false;
}

KonqRun::~KonqRun()
{
  kdDebug(1202) << "KonqRun::~KonqRun()" << endl;
}

void KonqRun::foundMimeType( const QString & _type )
{
  kdDebug(1202) << "FILTERING " << _type << endl;

  m_bFoundMimeType = true;

  assert( m_pMainView );

  if ( m_pMainView->openView( _type, m_strURL, m_pChildView ) )
  {
    m_pMainView = 0L;
    m_bFinished = true;
    m_timer.start( 0, true );
    return;
  }
  kdDebug(1202) << "Nothing special to do here" << endl;

  KRun::foundMimeType( _type );
}

#include "konq_run.moc"
