/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __MINIPAGER_H
#define __MINIPAGER_H

#include <qvaluelist.h>
#include <qbutton.h>
#include <qlayout.h>

#include "../../internalapplet.h"

class KProcess;

class KMiniPagerButton : public QButton
{
    Q_OBJECT
public:
    KMiniPagerButton(int desk, QWidget *parent=0, const char *name=0);
protected slots:
    void slotClicked();
signals:
    void deskChange(int desk);
protected:
    void paintEvent(QPaintEvent *ev);
    QString deskStr;
    int deskNum;
};

class KMiniPager : public InternalApplet
{
  Q_OBJECT;

 public:
    KMiniPager(QWidget *parent=0, const char *name=0);

    int widthForHeight(int height);
    int heightForWidth(int width);

public slots:
    void slotSetDesktop(int desktop);
    void slotSetDesktopCount(int count);
    void slotButtonClicked(int desk);

protected:
    void allocateButtons();
    void resizeEvent(QResizeEvent*);

    QValueList<KMiniPagerButton*>btnList;
    QGridLayout *layout;
    int curDesk;
};

#endif

