/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __KASBAR_H
#define __KASBAR_H

#include <qlist.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qwidget.h>
#include <../../internalapplet.h>

class KWinModule;
class QBoxLayout;

class KasItem
{
public:
    KasItem(WId w);
    ~KasItem();
    void refresh();
    bool onCurrentDesktop() const;
    inline WId window() const;
    inline QString text() const;
    inline QPixmap& icon() { return(pixmap); }
private:
    WId win;
    QString winStr;
    QPixmap pixmap;
    int desktop;
    bool sticky;
};

class KasBar : public QWidget
{
    Q_OBJECT
public:
    KasBar(Orientation o, QWidget* parent = 0, const char* name = 0);
    void setOrientation(Orientation o){ orient = o; updateLayout();}
    Orientation orientation(){ return(orient); }
    unsigned int buttons(){return(items.count());}
signals:
    void layoutChanged();
protected slots:
    void windowAdd(WId);
    void windowRemove(WId);
    void windowChange(WId);
    void windowActivate(WId);
    void desktopChange(int);
    void updateLayout();
protected:
    void mousePressEvent(QMouseEvent *ev);
    void paintEvent(QPaintEvent *ev);
    void resizeEvent(QResizeEvent *ev);
    void drawItem(QPainter *p, KasItem *i, int x, int y);
    void repaintItem(KasItem *i);
    KasItem* itemAt(const QPoint &p);
private:
    QList<KasItem> items;
    KasItem* findItem( WId w );
    Orientation orient;
    unsigned int maxBoxes;
};

class KasFrame : public InternalApplet
{
    enum Position { TopLeft = 0, TopRight, BottomLeft, BottomRight };
    Q_OBJECT
public:
    KasFrame(QWidget *parent=0, const char *name=0);
    void setOrientation(Orientation o){ orient = o; bar->setOrientation(o);}
    Orientation orientation(){ return(orient); }
    void setPosition(Position p){ pos = p; }
    Position position(){ return(pos); }
protected slots:
    void slotLayoutChanged();
    void moveMe();
protected:
    void mousePressEvent(QMouseEvent *ev);
    void mouseReleaseEvent(QMouseEvent *ev);
    void mouseMoveEvent(QMouseEvent *ev);
    void mouseDoubleClickEvent(QMouseEvent *ev);
    void paintEvent(QPaintEvent *ev);
    void reposition();
    KasBar *bar;
    Position pos;
    Orientation orient;
    bool minimized, inDrag;
    QPoint dragStart;
};


inline WId KasItem::window() const
{
    return win;
}

inline QString KasItem::text() const
{
    return winStr;
}


#endif
