/*
*
* minicli.h
* Copyright (C) 1997 Matthias Ettrich <ettrich@kde.org>
* copyright (C) 1997 Torben Weis [ Added command completion ]
* Copyright (C) 1999 Preston Brown <pbrown@kde.org>
*
* Complete re-write:
* Copyright (C) 1999 - 2000 Dawit Alemayehu <adawit@kde.org>
* Copyright (C) 2000 Malte Starostik <starosti@zedat.fu-berlin.de>
*/

#ifndef MINICLI_H
#define MINICLI_H

#include <qdialog.h>
#include <kurifilter.h>

class KComboBox;
class KCompletion;
class QLabel;
class QCheckBox;

class Minicli : public QDialog
{
    Q_OBJECT

public:
    Minicli( QWidget *parent=0, const char *name=0 );
    virtual ~Minicli();

public slots:
    bool setCWD( const QString& );
    void cleanup();

signals:
    void aboutToHide();

protected:
    void loadConfig();
    void saveConfig();
    void loadStandardGUI();
    void loadTraditionalGUI(){};
    void keyPressEvent( QKeyEvent * );
    void closeEvent( QCloseEvent* );
    void hideEvent ( QHideEvent* );

private slots:
    void slotCmdChanged( const QString& );
    void slotReturnPressed( const QString& );
    void slotTerminalToggled( bool );
    void slotParseTimer();
    void run_command();

private:
    QLabel *m_runIcon;
    QCheckBox* m_terminalBox;
    QTimer* m_parseTimer;
    QString m_strCWD;

    uint m_iMaxHistory;
    KComboBox* m_runCombo;
    KCompletion* m_pCompletion;
};

#endif

