#define __EMXPM__

#include "irc.h"
#include "struct.h"
#include "dcc.h"
#include "ircaux.h"
#include "ctcp.h"
#include "status.h"
#include "lastlog.h"
#include "server.h"
#include "screen.h"
#include "vars.h" 
#include "misc.h"
#include "output.h"
#include "module.h"
#include "hook.h"
#include "hash2.h"
#define INIT_MODULE
#include "modval.h"

#include <sys/time.h>

#define cparse convert_output_format

HAB     hnab = 0;
HMQ     hnmq = 0;
QMSG	nqmsg = { 0 };
HWND	hwndnClient = 0;
HDC	hndc = 0;
HVPS	hnvps = 0;
HWND    hwndNicklist = 0;
HWND    hwndscroller;

SBCDATA scrollerdata;

void nicklist_add  _((IrcCommandDll *intp, char *command, char *args, char *subargs));
int update_nicklist (char *, char *, char **);

void drawnicklist(int spos)
{
NickList *n, *list;
ChannelList *cptr;
char minibuffer[20];
int nickcount=0, k;

    cptr = lookup_channel(current_window->current_channel, from_server, 0);
    list = sorted_nicklist(cptr, NICKSORT_NORMAL);
       for(n = list; n; n = n->next) 
          {
             if(nickcount >= spos && nickcount < spos + 20)
                {
                minibuffer[0]='\0';
                if(n->voice)
                   strcpy(minibuffer, "+");
                if(n->chanop)
                   strcpy(minibuffer, "@");
                if(n->ircop)
                   strcat(minibuffer, "*");
                strcat(minibuffer, n->nick);
                for(k=strlen(minibuffer);k<15;k++)
                   minibuffer[k]=' ';
                minibuffer[15]='\0';
                VioSetCurPos(nickcount-spos, 0, hnvps);
                VioWrtTTY(minibuffer, strlen(minibuffer), hnvps); 
                }
             nickcount++;
          }
    if(nickcount<20)
       {
          for(k=nickcount;k<20;k++)
             {
             VioSetCurPos(k, 0, hnvps);
             VioWrtTTY("               ", 15, hnvps);
             }
       }
    if (spos > nickcount) 
       spos=nickcount-20;
    WinSendMsg(hwndscroller, SBM_SETSCROLLBAR, (MPARAM)spos, MPFROM2SHORT(0, nickcount - 20));
    WinSendMsg(hwndscroller, SBM_SETTHUMBSIZE, MPFROM2SHORT(20, nickcount), (MPARAM)NULL);
    clear_sorted_nicklist(&list);
}

int update_nicklist (char *which, char *str, char **unused)
{
USHORT pos;

if(hwndNicklist!=(HWND)NULL)
   {
   pos = (USHORT) WinSendMsg(hwndscroller, SBM_QUERYPOS, (MPARAM)NULL, (MPARAM)NULL);
   drawnicklist(pos);
   }
}

MRESULT EXPENTRY NicklistWndProc(hwnd, msg, mp1, mp2)
HWND   hwnd;
USHORT msg;
MPARAM mp1;
MPARAM mp2;
{
HPS   hps;

        switch(msg) {
        case WM_VSCROLL:
           drawnicklist(SHORT1FROMMP(mp2));
           break;
	case WM_PAINT:
	   hps = WinBeginPaint(hwnd, NULLHANDLE, NULL);
	   VioShowPS(20, NICKNAME_LEN, 0, hnvps);
	   WinEndPaint(hps);
 	   return (0L);
        case WM_SIZE:
 	   return (WinDefAVioWindowProc(hwnd, msg, (ULONG)mp1, (ULONG)mp2));
           break;
        }
return (WinDefWindowProc(hwnd, msg, mp1, mp2));
}

void nicklist_thread(void)
{
ChannelList *chan;
NickList *n;
SWP winpos;
int borderw, borderh, titleh, cx, cy;
ULONG fstyle = FCF_TITLEBAR | FCF_SHELLPOSITION | FCF_TASKLIST;
VIOCURSORINFO bleah;

   hnab = WinInitialize(0);
   hnmq = WinCreateMsgQueue(hnab, 0);
   WinRegisterClass(hnab, "NICKLIST", NicklistWndProc, CS_SIZEREDRAW, 0);
	hwndNicklist = WinCreateStdWindow(HWND_DESKTOP,
								   WS_VISIBLE,
								   &fstyle,
								   "NICKLIST",
								   "Nicks",
								   0L,
								   NULLHANDLE,
								   0L,
								   &hwndnClient);
	hndc = WinOpenWindowDC(hwndnClient);									  /* opens device context */
	VioCreatePS(&hnvps, 20, NICKNAME_LEN + 1, 1, 					  /* creates AVIO PS */
				1, 0);
	VioAssociate(hndc, hnvps);									  /* associates DC and AVIO PS */
	VioSetDeviceCellSize(current_window->screen->VIO_font_height, current_window->screen->VIO_font_width, hnvps);			  /* Set the font size */
	titleh=WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR);
        cx=NICKNAME_LEN*current_window->screen->VIO_font_width;
        cy=20*current_window->screen->VIO_font_height;
        WinSetWindowPos(hwndNicklist, HWND_TOP, 0, 0, cx + 15 /* scroller width */, cy + titleh, SWP_SIZE);
        scrollerdata.posFirst = 0;
        scrollerdata.posLast = 0;
        scrollerdata.posThumb = 0;
        scrollerdata.cVisible = 0;
        scrollerdata.cTotal = 0;
        hwndscroller = WinCreateWindow(hwndnClient, WC_SCROLLBAR, (PSZ)NULL, SBS_VERT | SBS_THUMBSIZE | SBS_AUTOSIZE | WS_VISIBLE, cx, 0, 15, cy, hwndnClient, HWND_TOP, 1L, &scrollerdata, NULL);
        bleah.yStart = 0;
        bleah.cEnd = 0;
        bleah.cx = 0;
        bleah.attr = -1;
        VioSetCurType(&bleah, hnvps);
        update_nicklist(NULL, NULL, NULL);
	while (WinGetMsg(hnab, &nqmsg, (HWND)NULL, 0, 0))
		 WinDispatchMsg(hnab, &nqmsg);
        WinDestroyMsgQueue(hnmq);
        WinTerminate(hnab);
}

void nicklist_add  (IrcCommandDll *intp, char *command, char *args, char *subargs)
{
if(hwndNicklist==(HWND)NULL)
    _beginthread((void *)nicklist_thread, NULL, 0xFFFF, NULL);
  else
     {
      VioAssociate((HDC)NULL, hnvps);
      VioDestroyPS(hnvps);
      WinDestroyWindow(hwndnClient);
      WinSendMsg(hwndnClient, WM_CLOSE, 0, 0);
      }
}

int Nicklist_Init(IrcCommandDll **intp, Function_ptr *global_table)
{
CtcpEntryDll *newc;
IrcVariableDll *newv;
IrcCommandDll *new;
char buffer[BIG_BUFFER_SIZE+1];
char *p;

	set_global_func(global_table);
	set_dll_name("Nicklist");

	add_module_proc(COMMAND_PROC, "Nicklist", "nl", "Add a nick list to window", 0, 0, nicklist_add, NULL);
	add_module_proc(HOOK_PROC, "Nicklist", NULL, "*", KICK_LIST, 1, NULL, update_nicklist);
	add_module_proc(HOOK_PROC, "Nicklist", NULL, "*", JOIN_LIST, 1, NULL, update_nicklist);
	add_module_proc(HOOK_PROC, "Nicklist", NULL, "*", MODE_LIST, 1, NULL, update_nicklist);
	add_module_proc(HOOK_PROC, "Nicklist", NULL, "*", LEAVE_LIST, 1, NULL, update_nicklist);
	add_module_proc(HOOK_PROC, "Nicklist", NULL, "*", SIGNOFF_LIST, 1, NULL, update_nicklist);
	add_module_proc(HOOK_PROC, "Nicklist", NULL, "*", NICKNAME_LIST, 1, NULL, update_nicklist);
	add_module_proc(HOOK_PROC, "Nicklist", NULL, "*", WINDOW_FOCUS_LIST, 1, NULL, update_nicklist);
	add_module_proc(HOOK_PROC, "Nicklist", NULL, "*", CHANNEL_SYNCH_LIST, 1, NULL, update_nicklist);
	add_module_proc(HOOK_PROC, "Nicklist", NULL, "*", CHANNEL_SWITCH_LIST, 1, NULL, update_nicklist);

	return 0;
}
 