/* hide.c
 *
 */

#ifndef NO_HOTEDGE

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include "Wharf.h"
#include "hide.h"


#define EDGE_THICKNESS 2	/* Thickness in pixels of edge window */


/* HideWharfMode is true if the Wharf is normally hidden. If this is
   so, then wharfActuallyHidden indicates whether the Wharf is
   actually hidden (true) or is temporarily popped up (false). */
static int HideWharfMode;
static int wharfActuallyHidden;

/* Current geometry of main window (relative to root) */
static int xMain, yMain, widthMain, heightMain;

static void hideWharfWindows(void);
static void showWharfWindows(void);
static int pointInRectangle(int x, int y, int xr, int yr, int wr, int hr);


/* Initialize this module */
void HideInit(void)
{
  HideWharfMode = FALSE;
  wharfActuallyHidden = FALSE;
}


/* Set the main window's current geometry */
void HideSetMainGeometry(int x, int y, int w, int h)
{
  xMain = x;
  yMain = y;
  widthMain = w;
  heightMain = h;
}


/* Enable or disable Wharf hiding */
void HideEnable(int enable)
{
  if (HideWharfMode != enable)
  {
    HideWharfMode = enable;
    if (enable)
      hideWharfWindows();
    else
      showWharfWindows();
  }
}


/* Pop up the Wharf if necessary */
void HidePopUp(void)
{
  if (wharfActuallyHidden)
    showWharfWindows();
}


/* If leaving Wharf, hide it.  (x,y) is coordinate of mouse relative
   to root.  Return true if we really did hide the Wharf. */
int HideOnLeaveNotify(Window w, int x, int y)
{
  if (wharfActuallyHidden)
    return FALSE;

  /* If the mouse enters a swallowed window, the containing button
     gets a LeaveNotify event.  We must ignore this event since the
     mouse is still inside the Wharf. */
  if (pointInRectangle(x, y, xMain, yMain, widthMain, heightMain))
    return FALSE;
  if (LastMapped != -1  &&  pointInRectangle(x, y, xLast, yLast, wLast, hLast))
    return FALSE;

  /* The mouse has really exited all buttons, so hide the Wharf */
  hideWharfWindows();
  return TRUE;
}


/* Pop down Wharf if necessary */
void HidePopDown(void)
{
  if (!wharfActuallyHidden)
    hideWharfWindows();
}

static void hideWharfWindows(void)
{
  /* If a folder was open, hide it */
  if (LastMapped != -1)
  {
    struct folder_info *f = &Folders[LastMapped];
    XUnmapWindow(dpy, f->win);
    f->mapped = NOTMAPPED;
    LastMapped = -1;
  }

  /* Hide main window */
  XUnmapWindow(dpy, main_win);
  XFlush(dpy);
  wharfActuallyHidden = TRUE;

  /* Tell AfterStep that we have finished hiding */
  SendText(fd, "HOT_EDGE_DETECT", 0);
}


static void showWharfWindows(void)
{
  XMapWindow(dpy, main_win);
  XRaiseWindow(dpy, main_win);
  XSync(dpy, 0);
  wharfActuallyHidden = FALSE;
}


/* True if (x,y) is inside the specified rectangle.  Suitable only for
   (x,y) reported by LeaveNotify. */
static int pointInRectangle(int x, int y, int xr, int yr, int wr, int hr)
{
  return (xr < x && x < xr+wr && yr < y && y < yr+hr);
}


#endif /*NO_HOTEDGE*/
