#ifndef NO_HOTEDGE

#include "../configure.h"

#include <stdio.h>
#include <X11/X.h>
#include "afterstep.h"
#include "menus.h"
#include "misc.h"
#include "screen.h"
#include "module.h"
#include "hotedge.h"


int HotEdgeEnabled = FALSE;	/* True if hot edges are enabled */


static PanFrame **hotEdgeFrame;


static void hotEdgeCheck(PanFrame *panframe);


/* Initialize the Hot Edge feature */
void HotEdgeInit(void)
{
  int i;

  HotEdgeEnabled = FALSE;
  Scr.PanFrameTop.hotEdgeNumber = HOT_EDGE_TOP;
  Scr.PanFrameRight.hotEdgeNumber = HOT_EDGE_RIGHT;
  Scr.PanFrameBottom.hotEdgeNumber = HOT_EDGE_BOTTOM;
  Scr.PanFrameLeft.hotEdgeNumber = HOT_EDGE_LEFT;
  Scr.PanFrameTop.hotEdgeCount = 0;
  Scr.PanFrameRight.hotEdgeCount = 0;
  Scr.PanFrameBottom.hotEdgeCount = 0;
  Scr.PanFrameLeft.hotEdgeCount = 0;
  if (npipes <= 0)
  {
    fprintf(stderr, "afterstep: npipes must be positive\n");
    exit(1);
  }
  hotEdgeFrame = (PanFrame **) safemalloc(npipes * sizeof(PanFrame *));
  for (i = 0;  i < npipes;  ++i)
    hotEdgeFrame[i] = NULL;
}


/* Activate a hot edge; return false if error */
int HotEdgeActivate(int n, int module)
{
  PanFrame *panframe;
  switch (n)
  {
    case HOT_EDGE_TOP:     panframe = &Scr.PanFrameTop;  break;
    case HOT_EDGE_RIGHT:   panframe = &Scr.PanFrameRight;  break;
    case HOT_EDGE_BOTTOM:  panframe = &Scr.PanFrameBottom;  break;
    case HOT_EDGE_LEFT:    panframe = &Scr.PanFrameLeft;  break;
    default:
      fprintf(stderr, "AfterStep: HOT_EDGE_ENABLE: bad edge number: %d\n", n);
      return FALSE;
  }
  HotEdgeEnabled = TRUE;
  ++ panframe->hotEdgeCount;
  hotEdgeFrame[module] = panframe;
  hotEdgeCheck(panframe);
  return TRUE;
}


/* Enable or disable the pan frames, depending on which hot edges are
   enabled */
void HotEdgeConfigure(void)
{
  hotEdgeCheck(&Scr.PanFrameTop);
  hotEdgeCheck(&Scr.PanFrameBottom);
  hotEdgeCheck(&Scr.PanFrameLeft);
  hotEdgeCheck(&Scr.PanFrameRight);
}


/* Called when mouse cursor enters an enabled hot edge */
void HotEdgeEnter(PanFrame *panframe)
{
  int i;

  for (i = 0;  i < npipes;  ++i)
    if (hotEdgeFrame[i] == panframe)
      SendPacket(i, M_HOT_EDGE_NOTIFY, 0, 0, 0, 0, 0, 0, 0, 0);
}


/* Enable or disable one pan frame, depending on whether its
   corresponding hot edge is enabled. */
static void hotEdgeCheck(PanFrame *panframe)
{
  int shouldBeMapped = (panframe->hotEdgeCount > 0);

  if (panframe->isMapped != shouldBeMapped)
  {
    if (shouldBeMapped)
      XMapRaised(dpy, panframe->win);
    else
      XUnmapWindow(dpy, panframe->win);
    panframe->isMapped = shouldBeMapped;    
  }
}

#endif /*NO_HOTEDGE*/
