/**************************************************************************

Copyright 1998-1999 Precision Insight, Inc., Cedar Park, Texas.
All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sub license, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice (including the
next paragraph) shall be included in all copies or substantial portions
of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
IN NO EVENT SHALL PRECISION INSIGHT AND/OR ITS SUPPLIERS BE LIABLE FOR
ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

**************************************************************************/

/*
 * Authors:
 *   Keith Whitwell <keithw@precisioninsight.com>
 *
 */

#ifdef GLX_DIRECT_RENDERING

#include <X11/Xlibint.h>
#include <stdio.h>

#include "drm.h"
#include "mga_xmesa.h"
#include "context.h"
#include "vbxform.h"
#include "matrix.h"
#include "simple_list.h"

#include "mgadd.h"
#include "mgastate.h"
#include "mgatex.h"
#include "mgaspan.h"
#include "mgadepth.h"
#include "mgatris.h"
#include "mgapipeline.h"
#include "mgabuffers.h"

#include "xf86dri.h"
#include "mga_xmesa.h"

#include "mga_dri.h"





#ifndef MGA_DEBUG
int MGA_DEBUG = (0
/*  		  | DEBUG_ALWAYS_SYNC */
/*  		  | DEBUG_VERBOSE_MSG */
/*   		  | DEBUG_VERBOSE_LRU */
/*  		  | DEBUG_VERBOSE_DRI */
/*  		  | DEBUG_VERBOSE_IOCTL */
/*   		  | DEBUG_VERBOSE_2D */
		  );
#endif


static mgaContextPtr      mgaCtx = 0;

mgaGlx_t	mgaglx;

static int count_bits(unsigned int n)
{
   int bits = 0;

   while (n > 0) {
      if (n & 1) bits++;
      n >>= 1;
   }
   return bits;
}

/* These functions are accessed by dlsym from dri_mesa_init.c:
 *
 * XMesaInitDriver
 * XMesaResetDriver
 * XMesaCreateVisual
 * XMesaDestroyVisual
 * XMesaCreateContext 
 * XMesaDestroyContext
 * XMesaCreateWindowBuffer
 * XMesaCreatePixmapBuffer
 * XMesaDestroyBuffer
 * XMesaSwapBuffers
 * XMesaMakeCurrent
 *
 * So this is kind of the public interface to the driver.  The driver
 * uses the X11 mesa driver context as a kind of wrapper around its
 * own driver context - but there isn't much justificiation for doing
 * it that way - the DRI might as well use a (void *) to refer to the
 * driver contexts.  Nothing in the X context really gets used.
 */


GLboolean XMesaInitDriver(__DRIscreenPrivate *sPriv)
{
   mgaScreenPrivate *mgaScreen;
   MGADRIPtr         serverInfo = (MGADRIPtr)sPriv->pDevPriv;

   /* Allocate the private area */
   mgaScreen = (mgaScreenPrivate *)Xmalloc(sizeof(mgaScreenPrivate));
   if (!mgaScreen) return GL_FALSE;

   mgaScreen->sPriv = sPriv;
   sPriv->private = (void *)mgaScreen;

   /*
   fprintf(stderr, "serverInfo->chipset: %d\n", serverInfo->chipset);
   */

   if (serverInfo->chipset != MGA_CARD_TYPE_G200 &&
       serverInfo->chipset != MGA_CARD_TYPE_G400)
	   return GL_FALSE;
   
   mgaScreen->chipset = serverInfo->chipset;
   mgaScreen->width = serverInfo->width;
   mgaScreen->height = serverInfo->height;
   mgaScreen->mem = serverInfo->mem;
   mgaScreen->cpp = serverInfo->cpp;
   mgaScreen->frontPitch = serverInfo->frontPitch;
   mgaScreen->frontOffset = serverInfo->frontOffset;
   mgaScreen->backOffset = serverInfo->backOffset; 
   mgaScreen->backPitch  =  serverInfo->backPitch;
   mgaScreen->depthOffset = serverInfo->depthOffset;
   mgaScreen->depthPitch  =  serverInfo->depthPitch;


   mgaScreen->agp_tex.handle = serverInfo->agp;
   mgaScreen->agp_tex.size = serverInfo->agpSize;

   if (drmMap(sPriv->fd, 
	      mgaScreen->agp_tex.handle, 
	      mgaScreen->agp_tex.size, 
	      (drmAddress *)&mgaScreen->agp_tex.map) != 0) 
   {
      Xfree(mgaScreen);
      return GL_FALSE;
   }



   mgaScreen->textureOffset[MGA_CARD_HEAP] = serverInfo->textureOffset;
   mgaScreen->textureOffset[MGA_AGP_HEAP] = (mgaScreen->agp_tex.handle |
					     PDEA_pagpxfer_enable | 1);

   /*
   fprintf(stderr, "CARD texture size %x, granul %d --> %x\n", 
	   serverInfo->textureSize, serverInfo->logTextureGranularity,
	   1<<serverInfo->logTextureGranularity);
   */

   mgaScreen->textureSize[MGA_CARD_HEAP] = serverInfo->textureSize;
   mgaScreen->textureSize[MGA_AGP_HEAP] = serverInfo->agpTextureSize;

   mgaScreen->logTextureGranularity[MGA_CARD_HEAP] = 
      serverInfo->logTextureGranularity;
   mgaScreen->logTextureGranularity[MGA_AGP_HEAP] = 
      serverInfo->logAgpTextureGranularity;

   mgaScreen->texVirtual[MGA_CARD_HEAP] = (mgaScreen->sPriv->pFB + 
					   mgaScreen->textureOffset[0]);
   mgaScreen->texVirtual[MGA_AGP_HEAP] = mgaScreen->agp_tex.map;

   mgaScreen->mAccess = serverInfo->mAccess;


   /*
   fprintf(stderr, "\n\n\nbackOffset: %x pitch %x\n", 
	   mgaScreen->backOffset,
	   mgaScreen->backPitch);
   */

   mgaScreen->Attrib = MGA_PF_565;
   mgaScreen->bufs = drmMapBufs(sPriv->fd);

   /* Other mgaglx stuff, too??
    */
   memset(&mgaglx, 0, sizeof(mgaglx));

   mgaDDFastPathInit();
   mgaDDTrifuncInit();
   mgaDDSetupInit();

   return GL_TRUE;
}

/* Accessed by dlsym from dri_mesa_init.c
 */
void XMesaResetDriver(__DRIscreenPrivate *sPriv)
{
   Xfree(sPriv->private);
}

/* Accessed by dlsym from dri_mesa_init.c
 */
XMesaVisual XMesaCreateVisual(XMesaDisplay *display,
			      XMesaVisualInfo visinfo,
			      GLboolean rgb_flag,
			      GLboolean alpha_flag,
			      GLboolean db_flag,
			      GLboolean stereo_flag,
			      GLboolean ximage_flag,
			      GLint depth_size,
			      GLint stencil_size,
                              GLint accum_red_size,
                              GLint accum_green_size,
                              GLint accum_blue_size,
                              GLint accum_alpha_size,
                              GLint num_samples,
                              GLint level,
                              GLint visualCaveat )
{
   XMesaVisual v;

   /* Only RGB visuals are supported on the MGA boards */
   if (!rgb_flag) return 0;

   v = (XMesaVisual)Xmalloc(sizeof(struct xmesa_visual));
   if (!v) return 0;

   v->visinfo = (XVisualInfo *)Xmalloc(sizeof(*visinfo));
   if(!v->visinfo) {
      Xfree(v);
      return 0;
   }
   memcpy(v->visinfo, visinfo, sizeof(*visinfo));

   v->display = display;
   v->level = level;  
   v->VisualCaveat = visualCaveat;
   v->gl_visual = _mesa_create_visual(rgb_flag,
                                      GL_FALSE,  /* alpha flag */
                                      db_flag,
                                      stereo_flag,
                                      count_bits(visinfo->red_mask),
                                      count_bits(visinfo->green_mask),
                                      count_bits(visinfo->blue_mask),
                                      0, /* alpha bits */
                                      0, /* index bits */
                                      depth_size,
                                      stencil_size,
                                      accum_red_size,
                                      accum_green_size,
                                      accum_blue_size,
                                      accum_alpha_size,
                                      0 /* num samples */ );
   if (!v->gl_visual) {
      Xfree(v->visinfo);
      Xfree(v);
      return NULL;
   }
   else
      return v;
}

void XMesaDestroyVisual(XMesaVisual v)
{
   _mesa_destroy_visual(v->gl_visual);
   Xfree(v->visinfo);
   Xfree(v);
}

XMesaContext XMesaCreateContext(XMesaVisual v, XMesaContext share_list,
				__DRIcontextPrivate *driContextPriv)
{
   int i;
   GLcontext *ctx;
   XMesaContext c;
   mgaContextPtr mmesa;
   __DRIscreenPrivate *sPriv = driContextPriv->driScreenPriv;
   mgaScreenPrivate *mgaScreen = (mgaScreenPrivate *)sPriv->private;
   drm_mga_sarea_t *saPriv=(drm_mga_sarea_t*)(((char*)sPriv->pSAREA)+
					      sizeof(XF86DRISAREARec));
   GLcontext *shareCtx = 0;

   /*fprintf(stderr, "XMesaCreateContext\n");*/

   c = (XMesaContext)Xmalloc(sizeof(struct xmesa_context));
   if (!c) {
      return 0;
   }

   mmesa = (mgaContextPtr)Xcalloc(sizeof(mgaContext), 1);
   if (!mmesa) {
      Xfree(c);
      return 0;
   }

   c->driContextPriv = driContextPriv;
   c->xm_visual = v;
   c->xm_buffer = 0; /* Set by MakeCurrent */
   c->display = v->display;
   c->private = (void *)mmesa;

   if (share_list)
      shareCtx=((mgaContextPtr)(share_list->private))->glCtx;

   ctx = mmesa->glCtx = gl_create_context(v->gl_visual, shareCtx, 
					  (void*)mmesa, GL_TRUE);

   mmesa->display = v->display;
   mmesa->hHWContext = driContextPriv->hHWContext;
   mmesa->driFd = sPriv->fd;
   mmesa->driHwLock = &sPriv->pSAREA->lock;

   mmesa->mgaScreen = mgaScreen;
   mmesa->driScreen = sPriv;
   mmesa->sarea = saPriv;

   mmesa->glBuffer=gl_create_framebuffer(v->gl_visual,
					 GL_FALSE,  /* software depth buffer? */
					 v->gl_visual->StencilBits > 0,
					 v->gl_visual->AccumRedBits > 0,
					 v->gl_visual->AlphaBits > 0);


   make_empty_list(&mmesa->SwappedOut);

   mmesa->lastTexHeap = mgaScreen->texVirtual[MGA_AGP_HEAP] ? 2 : 1;

   for (i = 0 ; i < mmesa->lastTexHeap ; i++) {
      mmesa->texHeap[i] = mmInit( 0, mgaScreen->textureSize[i]);
      make_empty_list(&mmesa->TexObjList[i]);
   }

   mmesa->renderindex = -1;		/* impossible value */
   mmesa->new_state = ~0;
   mmesa->dirty = ~0;
   mmesa->warp_pipe = 0;   
   mmesa->CurrentTexObj[0] = 0;
   mmesa->CurrentTexObj[1] = 0;
   
   mmesa->texAge[0] = 0;
   mmesa->texAge[1] = 0;
   

   mgaDDExtensionsInit( ctx );

   mgaDDInitStateFuncs( ctx );
   mgaDDInitTextureFuncs( ctx );
   mgaDDInitSpanFuncs( ctx );
   mgaDDInitDriverFuncs( ctx );
   mgaDDInitIoctlFuncs( ctx );


   ctx->Driver.TriangleCaps = (DD_TRI_CULL|
			       DD_TRI_LIGHT_TWOSIDE|
			       DD_TRI_STIPPLE|
			       DD_TRI_OFFSET);

   /* Ask mesa to clip fog coordinates for us.
    */
   ctx->TriangleCaps |= DD_CLIP_FOG_COORD;

   ctx->Shared->DefaultD[2][0].DriverData = 0;
   ctx->Shared->DefaultD[2][1].DriverData = 0;

   if (ctx->VB) 
      mgaDDRegisterVB( ctx->VB );

   if (ctx->NrPipelineStages)
      ctx->NrPipelineStages =
	 mgaDDRegisterPipelineStages(ctx->PipelineStage,
				      ctx->PipelineStage,
				      ctx->NrPipelineStages);

   mgaInitState( mmesa );

   return c;
}

void XMesaDestroyContext(XMesaContext c)
{
   mgaContextPtr mmesa = (mgaContextPtr) c->private;

   if (mmesa) {
/*        mgaTextureObjectPtr next_t, t; */

      gl_destroy_context(mmesa->glCtx);
      gl_destroy_framebuffer(mmesa->glBuffer);

/*        foreach_s (t, next_t, &(mmesa->TexObjList)) */
/*  	 mgaDestroyTexObj(mmesa, t); */

/*        foreach_s (t, next_t, &(mmesa->SwappedOut)) */
/*  	 mgaDestroyTexObj(mmesa, t); */

      Xfree(mmesa);

      c->private = 0;
   }
}

XMesaBuffer XMesaCreateWindowBuffer(XMesaVisual v, XMesaWindow w,
				    __DRIdrawablePrivate *driDrawPriv)
{
  return (XMesaBuffer)1;
}

XMesaBuffer XMesaCreatePixmapBuffer(XMesaVisual v, XMesaPixmap p,
				    XMesaColormap c, 
				    __DRIdrawablePrivate *driDrawPriv)
{
  return (XMesaBuffer)1;
}

void XMesaDestroyBuffer(XMesaBuffer b)
{
}

void XMesaSwapBuffers(XMesaBuffer bogus_value_do_not_use)
{
   mgaContextPtr mmesa = mgaCtx;    
   FLUSH_VB( mmesa->glCtx, "swap buffers" );
   mgaSwapBuffers(mmesa);
}




GLboolean XMesaUnbindContext(XMesaContext c)
{
   if (c->private)
      ((mgaContextPtr)c->private)->dirty = ~0;

   return GL_TRUE;
}


/* This looks buggy to me - the 'b' variable isn't used anywhere...
 * Hmm - It seems that the drawable is already hooked in to
 * driDrawablePriv.  
 *
 * But why are we doing context initialization here???
 */
GLboolean XMesaMakeCurrent(XMesaContext c, XMesaBuffer b)
{

   if (c->private==(void *)mgaCtx) return GL_TRUE;

   if (c) {
      __DRIdrawablePrivate *dPriv = c->driContextPriv->driDrawablePriv;

      mgaCtx = (mgaContextPtr)c->private;


      gl_make_current(mgaCtx->glCtx, mgaCtx->glBuffer);

      mgaCtx->driDrawable = dPriv;
      mgaCtx->dirty = ~0;
      mgaCtx->dirty_cliprects = (MGA_FRONT|MGA_BACK);

      if (!mgaCtx->glCtx->Viewport.Width)
	 gl_Viewport(mgaCtx->glCtx, 0, 0, dPriv->w, dPriv->h);

   } else {
      gl_make_current(0,0);
      mgaCtx = NULL;
   }

   return GL_TRUE;
}


void mgaGetLock( mgaContextPtr mmesa, GLuint flags ) 
{
   __DRIdrawablePrivate *dPriv = mmesa->driDrawable;
   drm_mga_sarea_t *sarea = mmesa->sarea;
   int me = mmesa->hHWContext;
   int i;

   drmGetLock(mmesa->driFd, mmesa->hHWContext, flags);	

   if (*(dPriv->pStamp) != dPriv->lastStamp) { 
      mmesa->setupdone = 0;
      mmesa->dirty_cliprects = (MGA_FRONT|MGA_BACK);
      mgaUpdateRects( mmesa, (MGA_FRONT|MGA_BACK) );
   }

   mmesa->dirty |= MGA_UPLOAD_CTX | MGA_UPLOAD_CLIPRECTS;

    mmesa->sarea->dirty |= MGA_UPLOAD_CTX; 

   if (sarea->ctxOwner != me) {
      mmesa->dirty |= (MGA_UPLOAD_CTX | MGA_UPLOAD_TEX0 | 
		       MGA_UPLOAD_TEX1 | MGA_UPLOAD_PIPE);
      sarea->ctxOwner=me;
   }

   for (i = 0 ; i < mmesa->lastTexHeap ; i++)
      if (sarea->texAge[i] != mmesa->texAge[i])
	 mgaAgeTextures( mmesa, i );

   sarea->last_quiescent = -1;	/* just kill it for now */
}






#endif
