#ifndef __XFORMS_H__
#define __XFORMS_H__

#include <glide.h>

#include "basics.h"
#include "mathutil.h"
/*#include "util.h"*/
/*#include "cpudetect.h"*/

#define VERTEX_OUTCODE_MASK  0x0000003f
#define VERTEX_CULLED_MASK   0x00000040

#ifdef USE_GLIDE3
/* This program was originally a glide2x program.  This is a replication
 * of the glide2x vertex structure for use with glide3x. */

typedef struct {
  float  sow;                   /* s texture ordinate (s over w) */
  float  tow;                   /* t texture ordinate (t over w) */  
  float  oow;                   /* 1/w (used mipmapping - really 0xfff/w) */
}  GrTmuVertex;

typedef struct
{
  float x, y, z;                /* X, Y, and Z of scrn space -- Z is ignored */
  float r, g, b;                /* R, G, B, ([0..255.0]) */
  float ooz;                    /* 65535/Z (used for Z-buffering) */
  float a;                      /* Alpha [0..255.0] */
  float oow;                    /* 1/W (used for W-buffering, texturing) */
  GrTmuVertex  tmuvtx[GLIDE_NUM_TMU];
} GrVertex;


#endif

typedef struct _vertex_data_
{
	GrVertex vertex;
	unsigned long flags;
} VertexData;

// function pointers
extern void (*XformVertex)(VertexData *vert, float *v);

void InitializeXforms(const CPUcaps *cpu_caps);
void SetXformsMatrix(Matrix m);
void BeginXforms();
unsigned long EndXforms();

typedef struct _xvertex_
{
	VertexData xformed_vert;
	float point[3];
	float norm[3];
	float diffuse;
	float specular;
	float eurodescence;
} XVertex;

void XformXVertex(XVertex *verts, int num_verts);

#endif // __XFORMS_H__

