/*
 *  desktop -- The 3dfx Desktop Demo 
 *  COPYRIGHT 3DFX INTERACTIVE, INC. 1999
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _WINDOW_STATE_H
#define _WINDOW_STATE_H

#include <X11/Xlib.h>
#include <3dfx.h>

#include "global.h"

enum Spider_State
{
  SPIDER_WALK,
  SPIDER_CORNER,
  SPIDER_TURN
};


typedef enum Spider_State Spider_State;

/* This structure is used for maintaining state information for each window */
struct Window_State
{
  /* This tells me which window this state goes with.  This is used as 
   * the sort key.
   */
  Window window_id;

  /* Is this window brand new */
  int init;

  /* This is the index into the window and vtx arrays */
  int index;

  /* Checks if this window has been used this frame, this is for determining
   * if a window has closed
   */
  FxU32 used;

  FxU32 color1;
  FxU32 color2;

  /* The world space coordinates of the window */
  float world_upper_left[4];
  float world_lower_right[4];

  /* These are for the bird's flight.  It is a force field model */
  /* Attractions are positive quantities */
  float attraction[4];
  /* repulsions are negative quantities */
  float repulsion;

  /* I only decorate windows with this flag set */
  int decorated;

  int spider_frame;
  Spider_State spider_state;
  Vector spider_position;
  Vector spider_velocity;
  /* This matrix aligns the spider with its velocity */
  Matrix spider_align;
  float spider_center_attraction;
  float spider_corner_attraction;
  int spider_corner;  
};
typedef struct Window_State Window_State;

void
window_state_insert (Window_State **list, int *n, Window_State *new_ws);

Window_State *
window_state_remove_key (Window_State **list, int *n, Window key);

Window_State *
window_state_remove_index (Window_State **list, int *n, int index);

int
window_state_search (Window_State **list, int *n, Window key);

void
window_state_update (Demo_State *state, Window_State **list, int *n);

#endif
