/*
 *  desktop -- The 3dfx Desktop Demo 
 *  COPYRIGHT 3DFX INTERACTIVE, INC. 1999
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __MODEL_H
#define __MODEL_H

#include "xforms.h"

typedef struct BBox BBox;
typedef struct Triangle Triangle;
typedef struct Mesh Mesh;
typedef struct Model Model;
typedef struct Model_Node Model_Node;
typedef struct Texture Texture;
typedef struct TexCoord TexCoord;
typedef struct Hierarchy_Node Hierarchy_Node;

struct BBox
{
  /* These are always axis aligned so I only need two points */
  Vector BLL; /* Back Lower Left Vertex */
  Vector FUR; /* Front Upper Right */
};

/* Structures for the gxf models */
struct Triangle
{
  /* Validity flag when used as texture coordinates */
  unsigned int v;
  unsigned int a, b, c;
};

struct Mesh
{
  /* Triangles */
  Triangle *triangles;
  unsigned long int ntriangles;

  Triangle *textris;

  /* These are the textures on the mesh */
  int diffuse_map;
  FxU32 diffuse_wrap;
  FxU8  diffuse_alpha;

  float 
    diffuse_r, 
    diffuse_g, 
    diffuse_b;

  float 
    specular_r,
    specular_g,
    specular_b,
    specular_R;
};

struct TexCoord
{
  float s;
  float t;
};

/* This is a model node.  This corresponds to GXFObjectNode and
 * GXFObject */
struct Model_Node
{
  char *name;

  /* The Vertex list */
  XVertex *verts;
  unsigned long int nverts;

  /* Texture coordinates */
  TexCoord *tverts;
  unsigned long int ntverts;

  /* Meshes */
  Mesh *meshes;
  unsigned int nmeshes;
  
  /* The matrix for this node */
  Matrix xform;

  /* Refer back to the containing Model for textures */
  Model *parent_model;

  /* Hierarchy data */
  /* How many children */
  unsigned long int nchildren;
  /* Hierarchy data for all of the children */
  Model_Node  **children;  

  /* Animation Data: number of frames is constant across an entire
   * model so the number of frames is stored in the containing Model
   */
  Matrix *frames;  
};

struct Anim_Frame
{
  int nframes;
  
};

struct Texture
{
  GrTexInfo texinfo;
  FxU32 offset;
};

/* This is a hierarchical model with animation and materials and
 * stuff.  This corresponds with GXFNode, and GFXScene.  */
struct Model
{
  /* The texture list */
  Texture *textures;
  unsigned long int ntextures;

  /* The Model_Node list */
  Model_Node *nodes;
  unsigned long int nnodes;

  /* Animation data */
  int nframes;

  /* A bounding box used for size control */
  BBox bbox;
};

struct Scene 
{
  Model *models;
  int nmodels;
};


/* These are bounding box functions */
void
make_new_bbox (BBox *box, Vector v);

void
add_point_to_bbox (BBox *box, Vector v);

void
scale_model_to_bbox_matrix  (Matrix scale, Model *m, BBox *desired);

#endif
