/*
 *  desktop -- The 3dfx Desktop Demo 
 *  COPYRIGHT 3DFX INTERACTIVE, INC. 1999
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _INIT_H
#define _INIT_H

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#include <glide.h>

#include <X11/Xlib.h>

#include "global.h"
#include "control.h"

extern key_t shmkeys[HTILES * VTILES];
extern int   shmids [HTILES * VTILES];
extern unsigned char* shmptrs[HTILES * VTILES]; 

#ifndef USE_GLIDE3
extern GrHwConfiguration hwconfig;
#endif
extern GrScreenResolution_t resolution;


extern Display *display;


void
connect_shm ();

Display*
init_X ();

void
init_glide ();

void
shutdown_glide ();

unsigned int
setup_desktop (GrVertex vtx[HTILES * VTILES][4],   
	       GrTexInfo textures[HTILES * VTILES]);

extern void
init_textures (Demo_State *state);

void
init_wave (Demo_State *state);

#endif
