/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.io.IOException;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;
import netscape.security.PrivilegeManager;
import sun.rmi.transport.proxy.RMIMasterSocketFactory;

class AsyncConnector
implements Runnable {
    protected RMIMasterSocketFactory master;
    protected RMISocketFactory factory;
    protected String host;
    protected int port;
    protected IOException exception;
    protected Socket socket;
    boolean cleanUp = false;
    private boolean connect_allowed = false;

    AsyncConnector(RMIMasterSocketFactory rMIMasterSocketFactory, RMISocketFactory rMISocketFactory, String string, int n) {
        this.master = rMIMasterSocketFactory;
        this.factory = rMISocketFactory;
        this.host = string;
        this.port = n;
        System.getSecurityManager().checkConnect(string, n);
        this.connect_allowed = true;
    }

    public void run() {
        try {
            if (this.connect_allowed) {
                PrivilegeManager.enablePrivilege((String)"UniversalConnect");
            }
            Socket socket = this.factory.createSocket(this.host, this.port);
            PrivilegeManager.revertPrivilege((String)"UniversalConnect");
            AsyncConnector asyncConnector = this;
            synchronized (asyncConnector) {
                this.socket = socket;
                this.notify();
            }
            this.master.rememberFactory(this.host, this.factory);
            asyncConnector = this;
            synchronized (asyncConnector) {
                if (this.cleanUp) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {}
                }
                return;
            }
        }
        catch (IOException iOException) {
            AsyncConnector asyncConnector = this;
            synchronized (asyncConnector) {
                this.exception = iOException;
                this.notify();
                return;
            }
        }
    }

    synchronized IOException getException() {
        return this.exception;
    }

    synchronized Socket getSocket() {
        return this.socket;
    }

    synchronized void notUsed() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
        this.cleanUp = true;
    }
}

